/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.service;

import jakarta.persistence.EntityNotFoundException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.qubership.integration.platform.catalog.model.system.OperationProtocol;
import org.qubership.integration.platform.catalog.persistence.configs.entity.AbstractLabel;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.IntegrationSystem;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.IntegrationSystemLabel;
import org.qubership.integration.platform.catalog.persistence.configs.repository.system.IntegrationSystemLabelsRepository;
import org.qubership.integration.platform.catalog.persistence.configs.repository.system.SystemRepository;
import org.qubership.integration.platform.catalog.service.ActionsLogService;
import org.qubership.integration.platform.catalog.service.SystemBaseService;
import org.qubership.integration.platform.designtime.catalog.exception.exceptions.SystemDeleteException;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.FilterRequestDTO;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.system.SystemSearchRequestDTO;
import org.qubership.integration.platform.designtime.catalog.service.ChainService;
import org.qubership.integration.platform.designtime.catalog.service.SystemModelService;
import org.qubership.integration.platform.designtime.catalog.service.filter.SystemFilterSpecificationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SystemService
extends SystemBaseService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SystemService.class);
    public static final String SYSTEM_WITH_ID_NOT_FOUND_MESSAGE = "Can't find system with id: ";
    private final SystemModelService systemModelService;
    private final SystemFilterSpecificationBuilder systemFilterSpecificationBuilder;
    private final ChainService chainService;
    private final IntegrationSystemLabelsRepository systemLabelsRepository;

    @Autowired
    public SystemService(SystemRepository systemRepository, SystemModelService systemModelService, IntegrationSystemLabelsRepository systemLabelsRepository, ActionsLogService actionLogger, SystemFilterSpecificationBuilder systemFilterSpecificationBuilder, @Lazy ChainService chainService) {
        super(systemRepository, actionLogger, systemLabelsRepository);
        this.systemModelService = systemModelService;
        this.systemFilterSpecificationBuilder = systemFilterSpecificationBuilder;
        this.chainService = chainService;
        this.systemLabelsRepository = systemLabelsRepository;
    }

    @Transactional
    public List<IntegrationSystem> getNotDeprecatedWithSpecs() {
        return this.systemRepository.findAllByNotDeprecatedAndWithSpecs();
    }

    @Transactional
    public List<IntegrationSystem> getNotDeprecatedAndByModelType(List<OperationProtocol> modelType) {
        return this.systemRepository.findAllByNotDeprecatedAndWithSpecsAndModelType(modelType);
    }

    @Transactional
    public List<IntegrationSystem> getAllDiscoveredServices() {
        return this.systemRepository.findAllByInternalServiceNameNotNull();
    }

    @Transactional
    public List<IntegrationSystem> searchSystems(SystemSearchRequestDTO systemSearchRequestDTO) {
        return this.systemRepository.searchForSystems(systemSearchRequestDTO.getSearchCondition());
    }

    @Transactional
    public List<IntegrationSystem> findByFilterRequest(List<FilterRequestDTO> filters) {
        Specification specification = this.systemFilterSpecificationBuilder.buildFilter(filters);
        return this.systemRepository.findAll(specification);
    }

    @Async
    public void updateSystemModelCompiledLibraryAsync(IntegrationSystem system) {
        this.systemModelService.updateCompiledLibrariesForSystem(system.getId());
    }

    @Transactional
    public IntegrationSystem findById(String systemId) {
        return (IntegrationSystem)this.systemRepository.findById((Object)systemId).orElseThrow(() -> new EntityNotFoundException(SYSTEM_WITH_ID_NOT_FOUND_MESSAGE + systemId));
    }

    @Transactional
    public void delete(String systemId) {
        if (this.chainService.isSystemUsedByChain(systemId)) {
            throw new SystemDeleteException("System used by one or more chains");
        }
        super.delete(systemId);
    }

    public void replaceLabels(IntegrationSystem system, List<IntegrationSystemLabel> newLabels) {
        if (newLabels == null) {
            return;
        }
        List finalNewLabels = newLabels;
        IntegrationSystem finalSystem = system;
        finalNewLabels.forEach(label -> label.setSystem(finalSystem));
        system.getLabels().removeIf(l -> !l.isTechnical() && !finalNewLabels.stream().map(AbstractLabel::getName).collect(Collectors.toSet()).contains(l.getName()));
        finalNewLabels.removeIf(l -> l.isTechnical() || finalSystem.getLabels().stream().filter(lab -> !lab.isTechnical()).map(AbstractLabel::getName).collect(Collectors.toSet()).contains(l.getName()));
        newLabels = this.systemLabelsRepository.saveAll(finalNewLabels);
        system.addLabels((Collection)newLabels);
    }
}

