/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.qubership.integration.platform.catalog.model.library.ElementDescriptor;
import org.qubership.integration.platform.catalog.persistence.configs.entity.AbstractEntity;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Dependency;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ContainerChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.repository.chain.ElementRepository;
import org.qubership.integration.platform.catalog.service.ActionsLogService;
import org.qubership.integration.platform.catalog.service.library.LibraryElementsService;
import org.qubership.integration.platform.catalog.util.ElementUtils;
import org.qubership.integration.platform.designtime.catalog.configuration.aspect.ChainModification;
import org.qubership.integration.platform.designtime.catalog.exception.exceptions.ElementCreationException;
import org.qubership.integration.platform.designtime.catalog.exception.exceptions.ElementTransferException;
import org.qubership.integration.platform.designtime.catalog.model.ChainDiff;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.element.CreateElementRequest;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.element.TransferElementRequest;
import org.qubership.integration.platform.designtime.catalog.service.ChainService;
import org.qubership.integration.platform.designtime.catalog.service.DependencyService;
import org.qubership.integration.platform.designtime.catalog.service.ElementService;
import org.qubership.integration.platform.designtime.catalog.service.EnvironmentService;
import org.qubership.integration.platform.designtime.catalog.service.OrderedElementService;
import org.qubership.integration.platform.designtime.catalog.service.SwimlaneService;
import org.qubership.integration.platform.designtime.catalog.utils.OldContainerUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.auditing.AuditingHandler;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class TransferableElementService
extends ElementService {
    protected final OldContainerUtils oldContainerUtils;
    private final DependencyService dependencyService;

    @Autowired
    public TransferableElementService(ElementRepository elementRepository, LibraryElementsService libraryService, @Lazy ChainService chainService, SwimlaneService swimlaneService, ActionsLogService actionLogger, AuditingHandler jpaAuditingHandler, EnvironmentService environmentService, OrderedElementService orderedElementService, ElementUtils elementUtils, OldContainerUtils oldContainerUtils, DependencyService dependencyService) {
        super(elementRepository, libraryService, chainService, swimlaneService, actionLogger, jpaAuditingHandler, environmentService, orderedElementService, elementUtils);
        this.oldContainerUtils = oldContainerUtils;
        this.dependencyService = dependencyService;
    }

    @ChainModification
    public ChainDiff create(String chainId, CreateElementRequest createElementRequest) {
        ChainElement newElement;
        ChainDiff chainDiff = new ChainDiff();
        String parentElementId = createElementRequest.getParentElementId();
        String elementType = createElementRequest.getType();
        if ("swimlane".equals(elementType)) {
            return this.swimlaneService.create(chainId);
        }
        if (parentElementId != null) {
            ChainElement parentElement = (ChainElement)this.findByIdAndChainId(parentElementId, chainId).orElseThrow(() -> new ElementCreationException("Element " + parentElementId + " does not exist in chain " + chainId));
            boolean restrictedParentContainer = this.isParentContainerRestricted(parentElement, Collections.singletonList(elementType));
            if (!(parentElement instanceof ContainerChainElement) || restrictedParentContainer) {
                String swimlaneId = Optional.ofNullable(parentElement.getSwimlane()).map(AbstractEntity::getId).orElse(null);
                createElementRequest.setSwimlaneId(swimlaneId);
                ChainElement newElement2 = this.create(chainDiff, chainId, createElementRequest);
                chainDiff.addCreatedElement(newElement2);
                chainDiff.merge(this.dependencyService.create(parentElement, newElement2));
                return chainDiff;
            }
            newElement = this.create(elementType, (ContainerChainElement)parentElement);
            chainDiff.addUpdatedElement(parentElement);
        } else {
            newElement = this.create(chainDiff, chainId, createElementRequest);
        }
        chainDiff.addCreatedElement(newElement);
        return chainDiff;
    }

    @ChainModification
    public ChainDiff transfer(String chainId, TransferElementRequest transferRequest) {
        String parentId = transferRequest.getParentId();
        String swimlaneId = transferRequest.getSwimlaneId();
        List elementIds = transferRequest.getElements();
        ArrayList elements = new ArrayList();
        this.findAllById(elementIds).forEach(element -> {
            elements.add(element);
            elements.addAll(this.oldContainerUtils.getAllOldStyleContainerChildren(element));
        });
        ChainDiff chainDiff = new ChainDiff();
        ContainerChainElement parentElement = null;
        if (parentId != null) {
            elements.forEach(element -> this.checkIfAllowedInContainers(element.getType()));
            ChainElement foundParentElement = (ChainElement)this.findByIdOptional(parentId).orElseThrow(() -> new ElementTransferException("Element with id " + parentId + " not found"));
            boolean restrictedParentContainer = this.isParentContainerRestricted(foundParentElement, elements.stream().map(ChainElement::getType).toList());
            if (!(foundParentElement instanceof ContainerChainElement) || restrictedParentContainer) {
                return this.createDependencies(foundParentElement, elementIds);
            }
            parentElement = (ContainerChainElement)foundParentElement;
            swimlaneId = Optional.ofNullable(parentElement.getSwimlane()).map(AbstractEntity::getId).orElse(swimlaneId);
        }
        List<String> foundElementIds = elements.stream().map(AbstractEntity::getId).toList();
        this.validateIntoItselfMovement(parentElement, foundElementIds);
        HashSet<String> oldParentIds = new HashSet<String>();
        for (ChainElement element2 : elements) {
            ContainerChainElement parentWithDeletedChild;
            String parentElementType = Optional.ofNullable(parentElement).map(ChainElement::getType).orElse(null);
            this.checkElementParentRestriction(element2.getType(), parentElementType);
            if (parentElement != null) {
                if (element2.getInputDependencies().isEmpty()) {
                    this.checkAddingChildParentRestriction(element2.getType(), parentElement);
                }
                parentElement.getElements().add(element2);
                if (this.orderedElementService.isOrdered(element2)) {
                    ChainDiff orderedChainDiff = this.orderedElementService.removeOrderedElement(element2.getParent(), element2);
                    this.saveAll(orderedChainDiff.getUpdatedElements());
                    chainDiff.merge(orderedChainDiff);
                    this.orderedElementService.calculatePriority(parentElement, element2);
                }
            }
            if ((parentWithDeletedChild = this.deleteElementFromParent(element2, false)) != null) {
                chainDiff.addUpdatedElement((ChainElement)parentWithDeletedChild);
                oldParentIds.add(parentWithDeletedChild.getId());
            } else {
                chainDiff.addUpdatedElement(element2);
            }
            this.validateTransferElementDependencies(element2, foundElementIds);
            element2.setParent(parentElement);
        }
        List savedElements = this.saveAll(elements);
        if (swimlaneId != null) {
            chainDiff.merge(this.swimlaneService.transferElementsToSwimlane(chainId, swimlaneId, elements));
        }
        if (parentElement != null) {
            if (this.isParentsNotInSet((ChainElement)parentElement, oldParentIds)) {
                chainDiff.addUpdatedElement((ChainElement)parentElement);
            }
        } else {
            chainDiff.addUpdatedElements(savedElements);
        }
        return chainDiff;
    }

    private boolean isParentContainerRestricted(ChainElement parentElement, List<String> elementTypes) {
        return Optional.ofNullable(this.libraryService.getElementDescriptor(parentElement)).filter(ElementDescriptor::isContainer).map(ElementDescriptor::getAllowedChildren).map(allowedChildren -> !allowedChildren.isEmpty() && elementTypes.stream().anyMatch(elementType -> !allowedChildren.containsKey(elementType))).orElse(false);
    }

    private ChainDiff createDependencies(ChainElement elementFrom, List<String> elementToIds) {
        this.validateIntoItselfMovement(elementFrom, elementToIds);
        ChainDiff chainDiff = new ChainDiff();
        this.findAllById(elementToIds).stream().peek(it -> this.validateTransferElementDependencies(it, elementToIds)).filter(it -> it.getInputDependencies().isEmpty()).peek(arg_0 -> this.validateIfInputEnabled(arg_0)).map(it -> this.dependencyService.create(elementFrom, it)).forEach(arg_0 -> ((ChainDiff)chainDiff).merge(arg_0));
        return chainDiff;
    }

    private void validateIntoItselfMovement(ChainElement parentElement, List<String> elementToIds) {
        while (parentElement != null) {
            if (elementToIds.contains(parentElement.getId())) {
                throw new ElementTransferException("Element cannot be transfer into itself");
            }
            parentElement = parentElement.getParent();
        }
    }

    private void validateIfInputEnabled(ChainElement element) {
        ElementDescriptor descriptor = this.libraryService.getElementDescriptor(element.getType());
        if (descriptor == null) {
            throw new ElementTransferException("The " + element.getType() + " with id " + element.getId() + " not found");
        }
        if (!descriptor.isInputEnabled()) {
            throw new ElementTransferException("The " + element.getType() + " input disabled");
        }
    }

    private void validateTransferElementDependencies(ChainElement element, List<String> transferElementsIds) {
        long inputsCount = element.getInputDependencies().stream().map(Dependency::getElementFrom).filter(elementFrom -> !transferElementsIds.contains(elementFrom.getId()) && !this.isElementParentTransferableOldStyleContainer(elementFrom, transferElementsIds)).count();
        long outputCounts = element.getOutputDependencies().stream().map(Dependency::getElementTo).filter(elementTo -> !transferElementsIds.contains(elementTo.getId())).count();
        if (inputsCount > 0L || outputCounts > 0L) {
            throw new ElementTransferException("Element " + element.getName() + " has input/output dependencies");
        }
    }

    private boolean isElementParentTransferableOldStyleContainer(ChainElement element, List<String> transferElementsIds) {
        if (element.getParent() == null || !this.oldContainerUtils.isOldStyleContainer(element.getParent().getType())) {
            return false;
        }
        return transferElementsIds.contains(element.getParent().getId());
    }

    private boolean isParentsNotInSet(ChainElement element, Set<String> ids) {
        ChainElement currentElement = element;
        while (currentElement.getParent() != null) {
            if (ids.contains(currentElement.getParent().getId())) {
                return false;
            }
            currentElement = currentElement.getParent();
        }
        return true;
    }
}

