/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.service.codeview;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.qubership.integration.platform.catalog.persistence.configs.entity.AbstractEntity;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.ActionLog;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.EntityType;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.LogOperation;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ContainerChainElement;
import org.qubership.integration.platform.catalog.service.ActionsLogService;
import org.qubership.integration.platform.designtime.catalog.configuration.aspect.ChainModification;
import org.qubership.integration.platform.designtime.catalog.exception.exceptions.ElementsCodeException;
import org.qubership.integration.platform.designtime.catalog.service.ChainService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.auditing.AuditingHandler;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ElementsCodeviewService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ElementsCodeviewService.class);
    private final ChainService chainService;
    private final YAMLMapper yamlMapper;
    private final ActionsLogService actionLogger;
    private final AuditingHandler auditingHandler;

    @Autowired
    public ElementsCodeviewService(ChainService chainService, YAMLMapper codeViewYamlMapper, ActionsLogService actionLogger, AuditingHandler auditingHandler) {
        this.chainService = chainService;
        this.yamlMapper = codeViewYamlMapper;
        this.actionLogger = actionLogger;
        this.auditingHandler = auditingHandler;
    }

    public String getElementsAsCode(String chainId) {
        try {
            Chain chain = this.chainService.findById(chainId);
            return this.yamlMapper.writeValueAsString((Object)chain.getElements());
        }
        catch (JsonProcessingException e) {
            throw new ElementsCodeException("Failed to save elements from YAML", (Throwable)e);
        }
    }

    @Deprecated(forRemoval=true, since="24.2")
    @ChainModification
    public List<ChainElement> saveElementsAsCode(String chainId, String elementsYaml) {
        try {
            List chainElements = (List)this.yamlMapper.readValue(elementsYaml, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            Chain chain = this.chainService.findById(chainId);
            Map parsedElements = chainElements.stream().collect(Collectors.toMap(AbstractEntity::getId, Function.identity()));
            this.mergeElements(parsedElements, chain.getElements());
            this.auditingHandler.markModified((Object)chain);
            this.logChainAction(chain, LogOperation.UPDATE);
            return chain.getRootElements();
        }
        catch (JsonProcessingException e) {
            throw new ElementsCodeException("Failed to save elements from YAML", (Throwable)e);
        }
    }

    @Deprecated(forRemoval=true, since="24.2")
    private void mergeElements(Map<String, ChainElement> parsedElements, List<ChainElement> originalElements) {
        for (ChainElement originalElement : originalElements) {
            ChainElement updatedElement = parsedElements.get(originalElement.getId());
            if (updatedElement == null) continue;
            if (updatedElement.getName() != null && !updatedElement.getName().isEmpty()) {
                originalElement.setName(updatedElement.getName());
            }
            originalElement.setDescription(updatedElement.getDescription());
            if (originalElement instanceof ContainerChainElement) continue;
            originalElement.getProperties().putAll(updatedElement.getProperties());
        }
    }

    @Deprecated(forRemoval=true, since="24.2")
    private void logChainAction(Chain chain, LogOperation operation) {
        this.actionLogger.logAction(ActionLog.builder().entityType(EntityType.CHAIN).entityId(chain.getId()).entityName(chain.getName()).parentType(chain.getParentFolder() == null ? null : EntityType.FOLDER).parentId(chain.getParentFolder() == null ? null : chain.getParentFolder().getId()).parentName(chain.getParentFolder() == null ? null : chain.getParentFolder().getName()).operation(operation).build());
    }
}

