/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.service.ddsgenerator;

import com.vladsch.flexmark.formatter.Formatter;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import freemarker.cache.StringTemplateLoader;
import freemarker.template.Configuration;
import io.micrometer.core.instrument.util.IOUtils;
import jakarta.persistence.EntityExistsException;
import jakarta.persistence.EntityNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.qubership.integration.platform.catalog.model.system.IntegrationSystemType;
import org.qubership.integration.platform.catalog.persistence.TransactionHandler;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.ActionLog;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.EntityType;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.LogOperation;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.DetailedDesignTemplate;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.Operation;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.SpecificationSource;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.SystemModel;
import org.qubership.integration.platform.catalog.persistence.configs.repository.DetailedDesignTemplateRepository;
import org.qubership.integration.platform.catalog.service.ActionsLogService;
import org.qubership.integration.platform.catalog.util.ResourceLoaderUtils;
import org.qubership.integration.platform.designtime.catalog.model.dds.TemplateData;
import org.qubership.integration.platform.designtime.catalog.model.dds.TemplateSequenceDiagram;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.dds.DDSResponse;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.dds.DDSSpecificationSource;
import org.qubership.integration.platform.designtime.catalog.service.ChainService;
import org.qubership.integration.platform.designtime.catalog.service.OperationService;
import org.qubership.integration.platform.designtime.catalog.service.SystemModelService;
import org.qubership.integration.platform.designtime.catalog.service.ddsgenerator.TemplateDataBuilder;
import org.qubership.integration.platform.designtime.catalog.service.ddsgenerator.TemplateDataBuilderException;
import org.qubership.integration.platform.designtime.catalog.service.ddsgenerator.exception.DetailedDesignInternalException;
import org.qubership.integration.platform.designtime.catalog.service.ddsgenerator.exception.TemplateDataEscapingException;
import org.qubership.integration.platform.designtime.catalog.service.ddsgenerator.exception.TemplateProcessingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.io.Resource;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DetailedDesignService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DetailedDesignService.class);
    public static final String CLASSPATH_DDS_TEMPLATES_PATTERN = "classpath*:dds/templates/*.ftl";
    public static final Pattern TEMPLATE_ID_PATTERN = Pattern.compile("^[a-zA-Z0-9_.-]+$");
    private final ChainService chainService;
    private final SystemModelService systemModelService;
    private final OperationService operationService;
    private final ActionsLogService actionLogger;
    private final TransactionHandler transactionHandler;
    private final TemplateDataBuilder templateDataBuilder;
    private final DetailedDesignTemplateRepository designTemplateRepository;
    private final StringTemplateLoader freemakerTemplateLoader;
    private final Configuration freemakerConfiguration;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Parser markdownParser;
    private final Formatter markdownRenderer;
    private final Map<String, Pair<String, String>> builtinTemplates = new HashMap();

    @Autowired
    public DetailedDesignService(ChainService chainService, SystemModelService systemModelService, OperationService operationService, ActionsLogService actionLogger, TransactionHandler transactionHandler, TemplateDataBuilder templateDataBuilder, DetailedDesignTemplateRepository designTemplateRepository, StringTemplateLoader freemakerTemplateLoader, Configuration freemakerConfig, Parser markdownParser, Formatter markdownRenderer) {
        this.chainService = chainService;
        this.systemModelService = systemModelService;
        this.operationService = operationService;
        this.actionLogger = actionLogger;
        this.transactionHandler = transactionHandler;
        this.templateDataBuilder = templateDataBuilder;
        this.designTemplateRepository = designTemplateRepository;
        this.freemakerTemplateLoader = freemakerTemplateLoader;
        this.freemakerConfiguration = freemakerConfig;
        this.markdownParser = markdownParser;
        this.markdownRenderer = markdownRenderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    @EventListener
    public void init(ApplicationReadyEvent event) {
        log.info("Detailed design templates loading started");
        try {
            Map resources = ResourceLoaderUtils.loadFiles((String)CLASSPATH_DDS_TEMPLATES_PATTERN);
            for (Map.Entry dirPathToDescriptorFile : resources.entrySet()) {
                this.loadBuiltinTemplate((String)dirPathToDescriptorFile.getKey(), (Resource)dirPathToDescriptorFile.getValue());
            }
            this.readWriteLock.writeLock().lock();
            try {
                this.transactionHandler.runInTransaction(() -> {
                    for (DetailedDesignTemplate template : this.designTemplateRepository.findAll()) {
                        this.freemakerTemplateLoader.putTemplate(template.getName(), template.getContent());
                    }
                });
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
            log.info("Detailed design templates loading finished");
        }
        catch (Exception e) {
            log.error("Detailed design templates loading failed", (Throwable)e);
        }
    }

    @Transactional
    public DDSResponse buildChainDetailedDesign(String chainId, String templateId) throws TemplateDataBuilderException, TemplateDataEscapingException {
        Map specs;
        Chain chain = this.chainService.findById(chainId);
        List elements = chain.getElements();
        TemplateData templateData = this.templateDataBuilder.build(chain, elements);
        StringWriter writer = new StringWriter();
        this.readWriteLock.readLock().lock();
        try {
            this.freemakerConfiguration.getTemplate(templateId).process((Object)templateData, (Writer)writer);
        }
        catch (Exception e) {
            log.warn("Failed to build detailed design from template '{}': {}", (Object)templateId, (Object)e.getMessage());
            throw new TemplateProcessingException("Failed to build detailed design from template '" + templateId + "': " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
        try {
            specs = this.collectImplementedSpecs(elements);
        }
        catch (Exception e) {
            log.error("Failed to collect implemented triggers specifications for chain: {}", (Object)chainId, (Object)e);
            throw new DetailedDesignInternalException("Failed to collect implemented triggers specifications for chain: " + e.getMessage(), (Throwable)e);
        }
        try {
            Document document = this.markdownParser.parse(((Object)writer).toString());
            TemplateSequenceDiagram simpleSeqDiagram = templateData.getChain().getDoc().getSimpleSeqDiagram();
            return DDSResponse.builder().document(this.markdownRenderer.render((Node)document)).simpleSeqDiagramPlantuml(simpleSeqDiagram.getPlantuml()).simpleSeqDiagramMermaid(simpleSeqDiagram.getMermaid()).triggerSpecifications(specs.values().stream().toList()).build();
        }
        catch (Exception e) {
            log.error("Failed to perform document formatting for chain: {}", (Object)chainId, (Object)e);
            throw new DetailedDesignInternalException("Failed to perform document formatting: " + e.getMessage(), (Throwable)e);
        }
    }

    @Transactional
    public List<DetailedDesignTemplate> findCustomTemplates() {
        return this.designTemplateRepository.findAll();
    }

    @Transactional
    public List<DetailedDesignTemplate> getBuiltInTemplates() {
        return this.builtinTemplates.entrySet().stream().map(entry -> ((DetailedDesignTemplate.DetailedDesignTemplateBuilder)((DetailedDesignTemplate.DetailedDesignTemplateBuilder)DetailedDesignTemplate.builder().id((String)entry.getKey())).name((String)((Pair)entry.getValue()).getLeft())).content((String)((Pair)entry.getValue()).getRight()).build()).toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public DetailedDesignTemplate createOrUpdateTemplate(String name, String content) {
        if (!this.checkTemplateName(name)) {
            throw new IllegalArgumentException("Invalid template name format: " + name + ", must match the pattern: " + TEMPLATE_ID_PATTERN.pattern());
        }
        String id = this.buildTemplateId(name);
        if (this.builtinTemplates.containsKey(id)) {
            throw new EntityExistsException(id);
        }
        DetailedDesignTemplate template = (DetailedDesignTemplate)this.designTemplateRepository.save((Object)((DetailedDesignTemplate.DetailedDesignTemplateBuilder)((DetailedDesignTemplate.DetailedDesignTemplateBuilder)DetailedDesignTemplate.builder().id(id)).name(name)).content(content).build());
        this.readWriteLock.writeLock().lock();
        try {
            this.freemakerTemplateLoader.putTemplate(template.getId(), template.getContent());
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
        this.logChainAction(id, LogOperation.CREATE_OR_UPDATE);
        return template;
    }

    @Transactional
    public void deleteTemplates(List<String> templateIds) {
        this.designTemplateRepository.deleteAllById(templateIds);
        for (String templateId : templateIds) {
            this.logChainAction(templateId, LogOperation.DELETE);
        }
    }

    @Transactional
    public DetailedDesignTemplate getTemplate(String templateId) {
        if (this.builtinTemplates.containsKey(templateId)) {
            Pair pair = (Pair)this.builtinTemplates.get(templateId);
            return ((DetailedDesignTemplate.DetailedDesignTemplateBuilder)((DetailedDesignTemplate.DetailedDesignTemplateBuilder)DetailedDesignTemplate.builder().id(this.buildTemplateId(templateId))).name((String)pair.getLeft())).content((String)pair.getRight()).build();
        }
        return (DetailedDesignTemplate)this.designTemplateRepository.findById((Object)templateId).orElseThrow(() -> new EntityNotFoundException("Detailed design template not found: " + templateId));
    }

    private Map<String, DDSSpecificationSource> collectImplementedSpecs(List<ChainElement> elements) {
        HashMap<String, DDSSpecificationSource> specs = new HashMap<String, DDSSpecificationSource>();
        for (ChainElement element : elements) {
            Operation operation;
            SystemModel spec;
            SpecificationSource src;
            String operationId;
            if (!"http-trigger".equals(element.getType()) || !IntegrationSystemType.IMPLEMENTED.toString().equals(element.getPropertyAsString("systemType")) || !StringUtils.isNotEmpty((CharSequence)(operationId = element.getPropertyAsString("integrationOperationId"))) || (src = this.systemModelService.getMainSystemModelSpecSource((spec = (operation = this.operationService.getOperation(operationId)).getSystemModel()).getId())) == null || !StringUtils.isNotEmpty((CharSequence)src.getSource())) continue;
            String specificationId = element.getPropertyAsString("integrationSpecificationId");
            String specificationFileContent = src.getSource();
            String specificationFileExt = FilenameUtils.getExtension((String)src.getName());
            if (specs.containsKey(specificationId)) continue;
            specs.put(specificationId, DDSSpecificationSource.builder().serviceName(spec.getSpecificationGroup().getSystem().getName()).specificationName(spec.getName()).specificationId(specificationId).fileExtension(specificationFileExt).specificationContent(specificationFileContent).build());
        }
        return specs;
    }

    @NotNull
    private String buildTemplateId(String name) {
        return name.toLowerCase();
    }

    private boolean checkTemplateName(String name) {
        return TEMPLATE_ID_PATTERN.matcher(name).find();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBuiltinTemplate(String dirPath, Resource descriptorFile) {
        block7: {
            try {
                int start = dirPath.lastIndexOf(47, dirPath.length() - 2) + 1;
                String elementName = dirPath.substring(start);
                if (log.isDebugEnabled()) {
                    log.debug("Processing element directory: {}", (Object)dirPath);
                }
                if (descriptorFile != null) {
                    String name = descriptorFile.getFilename();
                    name = name.substring(0, name.length() - 4);
                    log.debug("Loading detailed design template: '{}'", (Object)name);
                    String id = this.buildTemplateId(name);
                    String content = IOUtils.toString((InputStream)descriptorFile.getInputStream(), (Charset)StandardCharsets.UTF_8);
                    this.builtinTemplates.put(id, Pair.of((Object)name, (Object)content));
                    this.readWriteLock.writeLock().lock();
                    try {
                        this.freemakerTemplateLoader.putTemplate(id, content);
                        break block7;
                    }
                    finally {
                        this.readWriteLock.writeLock().unlock();
                    }
                }
                log.warn("Descriptor file is missing for {}, skipping", (Object)elementName);
            }
            catch (IOException e) {
                log.error("Error loading element descriptors", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    private void logChainAction(String templateId, LogOperation operation) {
        this.actionLogger.logAction(ActionLog.builder().id(templateId).entityName(templateId).entityType(EntityType.DETAILED_DESIGN_TEMPLATE).operation(operation).build());
    }
}

