/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.service.ddsgenerator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import lombok.Generated;
import org.qubership.integration.platform.catalog.model.designgenerator.DiagramLangType;
import org.qubership.integration.platform.catalog.model.designgenerator.DiagramMode;
import org.qubership.integration.platform.catalog.model.designgenerator.ElementsSequenceDiagram;
import org.qubership.integration.platform.catalog.model.system.IntegrationSystemType;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.designtime.catalog.model.dds.TemplateChain;
import org.qubership.integration.platform.designtime.catalog.model.dds.TemplateChainDoc;
import org.qubership.integration.platform.designtime.catalog.model.dds.TemplateChainElement;
import org.qubership.integration.platform.designtime.catalog.model.dds.TemplateChainElements;
import org.qubership.integration.platform.designtime.catalog.model.dds.TemplateChainMasking;
import org.qubership.integration.platform.designtime.catalog.model.dds.TemplateChainMaskingField;
import org.qubership.integration.platform.designtime.catalog.model.dds.TemplateData;
import org.qubership.integration.platform.designtime.catalog.model.dds.TemplateSequenceDiagram;
import org.qubership.integration.platform.designtime.catalog.service.ddsgenerator.TemplateDataBuilderException;
import org.qubership.integration.platform.designtime.catalog.service.ddsgenerator.elements.converter.ElementDDSConverter;
import org.qubership.integration.platform.designtime.catalog.service.ddsgenerator.exception.TemplateDataEscapingException;
import org.qubership.integration.platform.designtime.catalog.service.designgenerator.DesignGeneratorService;
import org.qubership.integration.platform.designtime.catalog.utils.escaping.EscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TemplateDataBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TemplateDataBuilder.class);
    public static final Function<ChainElement, Boolean> DEFAULT_ELEMENT_FILTER = element -> true;
    private final Map<String, ElementDDSConverter> elementConverters = new HashMap();
    private final DesignGeneratorService designGeneratorService;

    @Autowired
    public TemplateDataBuilder(List<ElementDDSConverter> elementConvertersList, DesignGeneratorService designGeneratorService) {
        this.designGeneratorService = designGeneratorService;
        elementConvertersList.forEach(converter -> converter.getTypes().forEach(type -> this.elementConverters.put(type, converter)));
    }

    public TemplateData build(Chain chain, List<ChainElement> chainElements) throws TemplateDataEscapingException, TemplateDataBuilderException {
        TemplateData data;
        try {
            List httpTriggersImplemented = this.convertByTypes(chainElements, Map.of("http-trigger", element -> IntegrationSystemType.IMPLEMENTED.toString().equals(element.getProperties().get("systemType"))));
            List httpTriggers = this.convertByTypes(chainElements, Map.of("http-trigger", DEFAULT_ELEMENT_FILTER));
            List httpServiceCalls = this.convertByTypes(chainElements, Map.of("service-call", element -> "http".equals(element.getProperty("integrationOperationProtocolType")) && element.getProperty("integrationSystemId") != null && element.getProperty("integrationSpecificationId") != null && element.getProperty("integrationOperationId") != null));
            List serviceCalls = this.convertByTypes(chainElements, Map.of("service-call", DEFAULT_ELEMENT_FILTER));
            List errorHandling = this.convertByTypes(chainElements, Map.of("service-call", element -> {
                Collection collection;
                Object patt0$temp = element.getProperty("after");
                return patt0$temp instanceof Collection && !(collection = (Collection)patt0$temp).isEmpty();
            }));
            List mappers = this.convertByTypes(chainElements, Map.of("mapper-2", DEFAULT_ELEMENT_FILTER));
            data = TemplateData.builder().chain(TemplateChain.builder().name(chain.getName()).description(chain.getDescription()).masking(TemplateChainMasking.builder().fields(chain.getMaskedFields().stream().map(field -> TemplateChainMaskingField.builder().name(field.getName()).build()).toList()).build()).doc(TemplateChainDoc.builder().businessDescription(chain.getBusinessDescription()).assumptions(chain.getAssumptions()).outOfScope(chain.getOutOfScope()).simpleSeqDiagram(this.buildSimpleSeqDiagram(chain)).build()).elements(TemplateChainElements.builder().httpTriggers(httpTriggers).httpTriggersImplemented(httpTriggersImplemented).httpServiceCalls(httpServiceCalls).withErrorHandling(errorHandling).withAuthorization(serviceCalls).mappers(mappers).build()).build()).build();
        }
        catch (TemplateDataBuilderException tdbe) {
            throw tdbe;
        }
        catch (Exception e) {
            log.error("Failed to convert chain data to TemplateData", (Throwable)e);
            throw new TemplateDataBuilderException("Failed to convert chain data to TemplateData: " + e.getMessage(), (Throwable)e);
        }
        try {
            EscapeUtils.escapeMarkdownDataRecursive((Object)data);
        }
        catch (Exception e) {
            log.error("Failed to escape chain detailed design template data", (Throwable)e);
            throw new TemplateDataEscapingException("Failed to escape chain detailed design template data: " + e.getMessage(), (Throwable)e);
        }
        return data;
    }

    private TemplateSequenceDiagram buildSimpleSeqDiagram(Chain chain) {
        Map diagrams = ((ElementsSequenceDiagram)this.designGeneratorService.generateChainSequenceDiagram(chain.getId(), List.of(DiagramMode.SIMPLE)).get(DiagramMode.SIMPLE)).getDiagramSources();
        return TemplateSequenceDiagram.builder().mermaid((String)diagrams.get(DiagramLangType.MERMAID)).plantuml((String)diagrams.get(DiagramLangType.PLANT_UML)).build();
    }

    private List<TemplateChainElement> convertByTypes(List<ChainElement> elements, Map<String, Function<ChainElement, Boolean>> typesFilter) throws TemplateDataBuilderException {
        ArrayList<TemplateChainElement> result = new ArrayList<TemplateChainElement>();
        for (ChainElement element : elements) {
            Function<ChainElement, Boolean> filterFunc;
            String elementType = element.getType();
            if (!typesFilter.containsKey(elementType) || !(filterFunc = typesFilter.get(elementType)).apply(element).booleanValue()) continue;
            ElementDDSConverter converter = (ElementDDSConverter)this.elementConverters.get(elementType);
            if (converter != null) {
                TemplateChainElement templateElement = converter.convert(element);
                if (templateElement == null) continue;
                result.add(templateElement);
                continue;
            }
            log.error("Converter for type: '{}' not implemented", (Object)elementType);
            throw new TemplateDataBuilderException("Converter for type: '" + elementType + "' not implemented");
        }
        return result;
    }
}

