/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.service.ddsgenerator.elements;

import com.fasterxml.jackson.databind.JsonNode;
import jakarta.persistence.EntityNotFoundException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.Operation;
import org.qubership.integration.platform.designtime.catalog.model.dds.TemplateSchema;
import org.qubership.integration.platform.designtime.catalog.service.OperationService;
import org.qubership.integration.platform.designtime.catalog.service.ddsgenerator.JsonSchemaParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ElementTemplateUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ElementTemplateUtils.class);
    private final JsonSchemaParser schemaToDDSConverter;
    private final OperationService operationService;

    @Autowired
    public ElementTemplateUtils(JsonSchemaParser schemaToDDSConverter, OperationService operationService) {
        this.schemaToDDSConverter = schemaToDDSConverter;
        this.operationService = operationService;
    }

    public void addJSONSchemas(Map<String, Object> elementProps, Map<String, Object> elementTemplateProps) {
        Map responseSchema;
        Operation operation;
        HashMap<String, TemplateSchema> templateRequestSchema = new HashMap<String, TemplateSchema>();
        HashMap templateResponseSchema = new HashMap();
        String operationId = (String)elementProps.get("integrationOperationId");
        boolean operationPresent = StringUtils.isNotEmpty((CharSequence)operationId);
        if (!operationPresent) {
            return;
        }
        try {
            operation = this.operationService.getOperation(operationId);
        }
        catch (EntityNotFoundException e) {
            return;
        }
        Map requestSchema = operation.getRequestSchema();
        if (requestSchema != null) {
            for (Map.Entry entry : requestSchema.entrySet()) {
                String key = (String)entry.getKey();
                if ("parameters".equals(key)) continue;
                JsonNode schemaNode = (JsonNode)entry.getValue();
                templateRequestSchema.put(key, this.schemaToDDSConverter.toProperties(schemaNode));
            }
        }
        if ((responseSchema = operation.getResponseSchemas()) != null) {
            for (Map.Entry entry : responseSchema.entrySet()) {
                String responseCode = (String)entry.getKey();
                HashMap<String, TemplateSchema> codeMapping = new HashMap<String, TemplateSchema>();
                templateResponseSchema.put(responseCode, codeMapping);
                JsonNode contentTypes = (JsonNode)entry.getValue();
                Iterator it = contentTypes.fieldNames();
                while (it.hasNext()) {
                    String contentType = (String)it.next();
                    JsonNode schemaNode = contentTypes.get(contentType);
                    codeMapping.put(contentType, this.schemaToDDSConverter.toProperties(schemaNode));
                }
            }
        }
        elementTemplateProps.put("requestSchema", templateRequestSchema);
        elementTemplateProps.put("responseSchema", templateResponseSchema);
    }
}

