/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.service.ddsgenerator.elements.converter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.designtime.catalog.model.dds.TemplateChainElement;
import org.qubership.integration.platform.designtime.catalog.service.ddsgenerator.elements.ElementTemplateUtils;
import org.qubership.integration.platform.designtime.catalog.service.ddsgenerator.elements.converter.ElementDDSConverter;
import org.qubership.integration.platform.designtime.catalog.service.ddsgenerator.elements.converter.RoutePrefixProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class HttpTriggerDDSConverter
extends ElementDDSConverter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpTriggerDDSConverter.class);
    private static final Map<String, String> TYPE_MAPPING = Map.of("http-trigger", "HTTP Trigger");
    private final ElementTemplateUtils elementTemplateUtils;
    private final ObjectMapper jsonMapper;
    private final RoutePrefixProvider routePrefixProvider;

    @Autowired
    public HttpTriggerDDSConverter(ElementTemplateUtils elementTemplateUtils, @Qualifier(value="primaryObjectMapper") ObjectMapper jsonMapper, RoutePrefixProvider routePrefixProvider) {
        this.elementTemplateUtils = elementTemplateUtils;
        this.jsonMapper = jsonMapper;
        this.routePrefixProvider = routePrefixProvider;
    }

    protected Map<String, String> getTypeMapping() {
        return TYPE_MAPPING;
    }

    public TemplateChainElement convert(ChainElement element) {
        Map elementProps = element.getProperties();
        HashMap<String, Object> elementTemplateProps = new HashMap<String, Object>();
        TemplateChainElement.TemplateChainElementBuilder builder = this.getBuilder(element);
        builder.properties(elementTemplateProps);
        String contextPath = elementProps.getOrDefault("contextPath", "");
        if (StringUtils.isEmpty((CharSequence)contextPath)) {
            contextPath = elementProps.getOrDefault("integrationOperationPath", "");
        }
        boolean isExternal = elementProps.getOrDefault("externalRoute", true);
        String httpMethodRestrict = (String)elementProps.get("httpMethodRestrict");
        List allowedContentTypes = (List)elementProps.get("allowedContentTypes");
        elementTemplateProps.put("endpointUri", this.routePrefixProvider.getRoutePrefix(isExternal) + StringUtils.strip((String)contextPath, (String)"/"));
        elementTemplateProps.put("endpointAllowedMethods", httpMethodRestrict == null ? "ALL" : httpMethodRestrict);
        elementTemplateProps.put("validateRequestContentType", allowedContentTypes == null || allowedContentTypes.isEmpty() ? "ALL" : String.join((CharSequence)", ", allowedContentTypes));
        try {
            List rolesList = elementProps.getOrDefault("roles", Collections.emptyList());
            HashMap value = new HashMap();
            value.put("type", elementProps.get("accessControlType"));
            value.put("roles", (rolesList.isEmpty() ? "Any role" : this.jsonMapper.writeValueAsString(rolesList)).replace("\"", ""));
            value.put("resource", elementProps.get("abacResource"));
            elementTemplateProps.put("accessControl", value);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        this.elementTemplateUtils.addJSONSchemas(elementProps, elementTemplateProps);
        return builder.build();
    }
}

