/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.service.designgenerator;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.catalog.model.designgenerator.DiagramConstants;
import org.qubership.integration.platform.catalog.model.designgenerator.DiagramLangType;
import org.qubership.integration.platform.catalog.model.designgenerator.DiagramMode;
import org.qubership.integration.platform.catalog.model.designgenerator.DiagramOperationType;
import org.qubership.integration.platform.catalog.model.designgenerator.ElementsSequenceDiagram;
import org.qubership.integration.platform.catalog.model.library.ElementDescriptor;
import org.qubership.integration.platform.catalog.model.library.ElementType;
import org.qubership.integration.platform.catalog.model.library.chaindesign.ContainerChildrenParameters;
import org.qubership.integration.platform.catalog.model.library.chaindesign.ElementContainerDesignParameters;
import org.qubership.integration.platform.catalog.model.library.chaindesign.ElementDesignParameters;
import org.qubership.integration.platform.catalog.model.library.chaindesign.ElementDiagramOperation;
import org.qubership.integration.platform.catalog.persistence.configs.entity.AbstractEntity;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Dependency;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ContainerChainElement;
import org.qubership.integration.platform.catalog.service.library.LibraryElementsService;
import org.qubership.integration.platform.catalog.util.DiagramBuilderEscapeUtil;
import org.qubership.integration.platform.designtime.catalog.service.ChainService;
import org.qubership.integration.platform.designtime.catalog.service.DependencyService;
import org.qubership.integration.platform.designtime.catalog.service.ElementService;
import org.qubership.integration.platform.designtime.catalog.service.designgenerator.SequenceDiagramBuilder;
import org.qubership.integration.platform.designtime.catalog.service.designgenerator.processors.interfaces.ContainerDesignProcessor;
import org.qubership.integration.platform.designtime.catalog.service.designgenerator.processors.interfaces.DesignProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class DesignGeneratorService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DesignGeneratorService.class);
    private static final Set<String> SIMPLE_DIAGRAM_ELEMENT_EXCLUDE_SET = Set.of("file-read", "file-write", "sftp-trigger-2", "sftp-trigger", "sftp-download", "sftp-upload", "log-record", "header-modification", "mapper", "mapper-2", "script", "xslt");
    private final Map<String, DesignProcessor> designProcessors = new HashMap();
    private final ElementService elementService;
    private final DependencyService dependencyService;
    private final LibraryElementsService libraryService;
    private final ChainService chainService;

    @Autowired
    public DesignGeneratorService(ElementService elementService, DependencyService dependencyService, LibraryElementsService libraryService, ChainService chainService, List<DesignProcessor> processors) {
        this.elementService = elementService;
        this.dependencyService = dependencyService;
        this.libraryService = libraryService;
        this.chainService = chainService;
        for (DesignProcessor processor : processors) {
            for (String supportedElementType : processor.supportedElementTypes()) {
                this.designProcessors.put(supportedElementType, processor);
            }
        }
    }

    public Map<DiagramMode, ElementsSequenceDiagram> generateChainSequenceDiagram(String chainId, List<DiagramMode> modes) {
        List elements = this.elementService.findAllByChainId(chainId);
        List dependencies = this.dependencyService.findAllByElementsIDs(elements.stream().map(AbstractEntity::getId).collect(Collectors.toList()));
        return this.generateSequenceDiagrams(chainId, null, elements, dependencies, modes);
    }

    public Map<DiagramMode, ElementsSequenceDiagram> generateSnapshotSequenceDiagram(String chainId, String snapshotId, List<DiagramMode> modes) {
        List elements = this.elementService.findAllBySnapshotId(snapshotId);
        List dependencies = this.dependencyService.findAllByElementsIDs(elements.stream().map(AbstractEntity::getId).collect(Collectors.toList()));
        return this.generateSequenceDiagrams(chainId, snapshotId, elements, dependencies, modes);
    }

    private Map<DiagramMode, ElementsSequenceDiagram> generateSequenceDiagrams(String chainId, String snapshotId, List<ChainElement> elements, List<Dependency> dependencies, List<DiagramMode> modes) {
        HashMap<DiagramMode, ElementsSequenceDiagram> result = new HashMap<DiagramMode, ElementsSequenceDiagram>();
        for (DiagramMode mode : modes) {
            result.put(mode, ElementsSequenceDiagram.builder().chainId(chainId).snapshotId(snapshotId).diagramSources(this.generateSequenceDiagram(chainId, elements, dependencies, mode)).build());
        }
        return result;
    }

    private Map<DiagramLangType, String> generateSequenceDiagram(String chainId, List<ChainElement> elements, List<Dependency> dependencies, DiagramMode mode) {
        Map fromElementMap = dependencies.stream().collect(Collectors.groupingBy(e -> e.getElementFrom().getId(), Collectors.mapping(Dependency::getElementTo, Collectors.toList())));
        this.collectReuseDependencies(elements, fromElementMap);
        SequenceDiagramBuilder builder = new SequenceDiagramBuilder();
        HashSet addedElementsIds = new HashSet();
        builder.append(DiagramOperationType.DOCUMENT_START, new String[0]).append(DiagramOperationType.AUTONUMBER, new String[0]);
        builder.append(DiagramOperationType.BLOCK_DELIMITER, new String[0]);
        List triggers = elements.stream().filter(chainElement -> this.libraryService.getElementDescriptor(chainElement) != null && this.libraryService.getElementDescriptor(chainElement).getType() == ElementType.TRIGGER).sorted(Comparator.comparing(AbstractEntity::getName)).collect(Collectors.toList());
        this.addParticipants(chainId, builder, triggers, fromElementMap, addedElementsIds, mode);
        for (ChainElement trigger : triggers) {
            String refChainId = DiagramBuilderEscapeUtil.removeOrReplaceUnsupportedCharacters((String)chainId);
            builder.append(DiagramOperationType.BLOCK_DELIMITER, new String[0]);
            builder.append(DiagramOperationType.START_GROUP, new String[]{trigger.getName()});
            builder.append(DiagramOperationType.START_COLORED_GROUP, new String[]{DiagramConstants.GROUP_BG_RGB[0], DiagramConstants.GROUP_BG_RGB[1], DiagramConstants.GROUP_BG_RGB[2], refChainId, trigger.getName()});
            builder.append(DiagramOperationType.ACTIVATE, new String[]{refChainId});
            this.generateDiagramRecursive(refChainId, builder, trigger, fromElementMap, addedElementsIds, mode);
            builder.append(DiagramOperationType.DEACTIVATE, new String[]{refChainId});
            builder.append(DiagramOperationType.END, new String[0]);
            builder.append(DiagramOperationType.BLOCK_DELIMITER, new String[0]);
        }
        builder.append(DiagramOperationType.BLOCK_DELIMITER, new String[0]);
        builder.append(DiagramOperationType.DOCUMENT_END, new String[0]);
        return builder.build();
    }

    private void addParticipants(String chainId, SequenceDiagramBuilder builder, List<ChainElement> triggers, Map<String, List<ChainElement>> fromElementMap, Set<String> addedElementsIds, DiagramMode mode) {
        LinkedHashMap<String, CallSite> participants = new LinkedHashMap<String, CallSite>();
        participants.put(DiagramBuilderEscapeUtil.removeOrReplaceUnsupportedCharacters((String)chainId), (CallSite)((Object)("QIP chain: " + this.chainService.findById(chainId).getName())));
        for (ChainElement chainElement : triggers) {
            addedElementsIds.add(chainElement.getId());
            this.addParticipant(chainId, participants, chainElement);
        }
        for (ChainElement chainElement : triggers) {
            for (ChainElement nextElement : this.getNextElements(chainElement, fromElementMap)) {
                this.addParticipantsRecursive(chainId, participants, nextElement, fromElementMap, addedElementsIds, mode);
            }
        }
        for (Map.Entry entry : participants.entrySet()) {
            builder.append(DiagramOperationType.PARTICIPANT_AS, new String[]{(String)entry.getKey(), (String)entry.getValue()});
        }
    }

    private void addParticipantsRecursive(String chainId, Map<String, String> participants, ChainElement currentElement, Map<String, List<ChainElement>> fromElementMap, Set<String> addedElementsIds, DiagramMode mode) {
        if (currentElement == null) {
            return;
        }
        if (!addedElementsIds.contains(currentElement.getId())) {
            addedElementsIds.add(currentElement.getId());
            if (DesignGeneratorService.shouldWriteElement((ChainElement)currentElement, (DiagramMode)mode)) {
                this.addParticipant(chainId, participants, currentElement);
            }
            if (currentElement instanceof ContainerChainElement) {
                for (ChainElement innerElement : ((ContainerChainElement)currentElement).getElements()) {
                    if (!innerElement.getInputDependencies().isEmpty()) continue;
                    this.addParticipantsRecursive(chainId, participants, innerElement, fromElementMap, addedElementsIds, mode);
                }
            }
            for (ChainElement nextElement : this.getNextElements(currentElement, fromElementMap)) {
                if (addedElementsIds.contains(nextElement.getId())) continue;
                this.addParticipantsRecursive(chainId, participants, nextElement, fromElementMap, addedElementsIds, mode);
            }
        }
    }

    private List<ChainElement> getNextElements(ChainElement currentElement, Map<String, List<ChainElement>> fromElementMap) {
        return fromElementMap.getOrDefault(currentElement.getId(), Collections.emptyList());
    }

    private void addParticipant(String chainId, Map<String, String> participants, ChainElement element) {
        String participantId;
        String participantName;
        ElementDesignParameters designParameters = this.libraryService.getElementDescriptor(element).getDesignParameters();
        DesignProcessor designProcessor = (DesignProcessor)this.designProcessors.get(element.getType());
        if (designParameters == null) {
            if (designProcessor == null) {
                return;
            }
            participantName = designProcessor.getExternalParticipantName(element);
            participantId = designProcessor.getExternalParticipantId(element);
        } else {
            participantName = designParameters.getExternalParticipantName(chainId, element);
            participantId = designParameters.getExternalParticipantId(chainId, element);
        }
        if (participantName != null) {
            participants.put(participantId, participantName);
        }
    }

    private void generateDiagramRecursive(String refChainId, SequenceDiagramBuilder builder, ChainElement currentElement, Map<String, List<ChainElement>> fromElementMap, Set<String> elementsToProcessIds, DiagramMode mode) {
        if (currentElement == null) {
            return;
        }
        List elementsTo = fromElementMap.getOrDefault(currentElement.getId(), Collections.emptyList());
        ElementDescriptor elementDescriptor = this.libraryService.getElementDescriptor(currentElement);
        DesignProcessor designProcessor = (DesignProcessor)this.designProcessors.get(currentElement.getType());
        if (elementsToProcessIds.contains(currentElement.getId())) {
            elementsToProcessIds.remove(currentElement.getId());
            if (elementDescriptor.isContainer()) {
                this.processContainerElement(refChainId, builder, (ContainerChainElement)currentElement, fromElementMap, elementsToProcessIds, mode, elementDescriptor, designProcessor, elementsTo);
            } else {
                this.processElement(refChainId, builder, currentElement, fromElementMap, elementsToProcessIds, mode, elementDescriptor, elementsTo, designProcessor);
            }
        }
    }

    private void processContainerElement(String refChainId, SequenceDiagramBuilder builder, ContainerChainElement currentElement, Map<String, List<ChainElement>> fromElementMap, Set<String> elementsToProcessIds, DiagramMode mode, ElementDescriptor elementDescriptor, DesignProcessor designProcessor, List<ChainElement> elementsTo) {
        if (ElementType.REUSE == elementDescriptor.getType()) {
            currentElement.getElements().stream().filter(child -> child.getInputDependencies().isEmpty()).forEach(child -> this.generateDiagramRecursive(refChainId, builder, child, fromElementMap, elementsToProcessIds, mode));
            return;
        }
        ElementContainerDesignParameters designParameters = elementDescriptor.getDesignContainerParameters();
        if (designParameters == null) {
            if (designProcessor instanceof ContainerDesignProcessor) {
                ContainerDesignProcessor containerProcessor = (ContainerDesignProcessor)designProcessor;
                this.processContainerWithDesignProcessor(refChainId, builder, currentElement, fromElementMap, elementsToProcessIds, mode, elementsTo, containerProcessor);
            }
        } else {
            this.processContainerWithDesignParams(refChainId, builder, currentElement, fromElementMap, elementsToProcessIds, mode, elementsTo, designParameters);
        }
    }

    private void processContainerWithDesignProcessor(String refChainId, SequenceDiagramBuilder builder, ContainerChainElement currentElement, Map<String, List<ChainElement>> fromElementMap, Set<String> elementsToProcessIds, DiagramMode mode, List<ChainElement> elementsTo, ContainerDesignProcessor containerProcessor) {
        List sortedChildren = currentElement.getElements().stream().filter(containerProcessor.getChildrenFilter()).sorted(containerProcessor.getComparator()).toList();
        containerProcessor.processBefore(refChainId, builder, (ChainElement)currentElement);
        for (ChainElement child : sortedChildren) {
            if (!containerProcessor.isContainerWithRestrictions()) {
                containerProcessor.processChildBefore(refChainId, builder, (ChainElement)currentElement, child);
                this.generateDiagramRecursive(refChainId, builder, child, fromElementMap, elementsToProcessIds, mode);
                containerProcessor.processChildAfter(refChainId, builder, (ChainElement)currentElement, child);
                continue;
            }
            containerProcessor.processChildBefore(refChainId, builder, (ChainElement)currentElement, child);
            if (child instanceof ContainerChainElement) {
                ContainerChainElement childContainer = (ContainerChainElement)child;
                childContainer.getElements().stream().filter(element -> element.getInputDependencies().isEmpty()).forEach(element -> this.generateDiagramRecursive(refChainId, builder, element, fromElementMap, elementsToProcessIds, mode));
            } else {
                List childElementsTo = fromElementMap.getOrDefault(child.getId(), Collections.emptyList());
                this.toNextElements(refChainId, builder, fromElementMap, childElementsTo, elementsToProcessIds, mode);
            }
            containerProcessor.processChildAfter(refChainId, builder, (ChainElement)currentElement, child);
        }
        containerProcessor.processAfter(refChainId, builder, (ChainElement)currentElement);
        this.toNextElements(refChainId, builder, fromElementMap, elementsTo, elementsToProcessIds, mode);
    }

    private void processContainerWithDesignParams(String refChainId, SequenceDiagramBuilder builder, ContainerChainElement currentElement, Map<String, List<ChainElement>> fromElementMap, Set<String> elementsToProcessIds, DiagramMode mode, List<ChainElement> elementsTo, ElementContainerDesignParameters designParameters) {
        List endOperations = designParameters.getEndOperations();
        List childrenParameters = designParameters.getChildren();
        Map innerElementsMap = currentElement.getElements().stream().collect(Collectors.groupingBy(ChainElement::getType, Collectors.mapping(Function.identity(), Collectors.toList())));
        boolean firstChildrenDetected = false;
        boolean atLeastOneChildHasDependency = false;
        for (ContainerChildrenParameters childrenParams : childrenParameters) {
            List children = innerElementsMap.getOrDefault(childrenParams.getName(), Collections.emptyList());
            boolean firstElementDetected = false;
            for (ChainElement child : children) {
                ElementDiagramOperation operation;
                Runnable nextElementsFunction;
                boolean childHasElements;
                if (child instanceof ContainerChainElement) {
                    ContainerChainElement childContainer = (ContainerChainElement)child;
                    childHasElements = !childContainer.getElements().isEmpty();
                    List<ChainElement> startElements = childContainer.getElements().stream().filter(element -> element.getInputDependencies().isEmpty()).toList();
                    nextElementsFunction = () -> startElements.forEach(startElement -> this.generateDiagramRecursive(refChainId, builder, startElement, fromElementMap, elementsToProcessIds, mode));
                } else {
                    List childElementsTo = fromElementMap.getOrDefault(child.getId(), Collections.emptyList());
                    childHasElements = !childElementsTo.isEmpty();
                    nextElementsFunction = () -> this.toNextElements(refChainId, builder, fromElementMap, childElementsTo, elementsToProcessIds, mode);
                }
                if (!childHasElements) continue;
                atLeastOneChildHasDependency = true;
                if (!firstElementDetected || childrenParams.getSecondaryOperation() == null) {
                    operation = childrenParams.getPrimaryOperation();
                    if (designParameters.getFirstChildrenType() != null && !firstChildrenDetected) {
                        operation.setType(designParameters.getFirstChildrenType());
                    } else if (designParameters.getChildrenType() != null) {
                        operation.setType(designParameters.getChildrenType());
                    }
                    firstChildrenDetected = true;
                    firstElementDetected = true;
                } else {
                    operation = childrenParams.getSecondaryOperation();
                }
                ArrayList<String> argsList = new ArrayList<String>();
                for (String arg : operation.getArgs()) {
                    argsList.add(DiagramBuilderEscapeUtil.substituteProperties((String)refChainId, (ChainElement)child, (String)arg));
                }
                builder.append(operation.getType(), argsList.toArray(new String[0]));
                nextElementsFunction.run();
            }
        }
        if (atLeastOneChildHasDependency) {
            for (ElementDiagramOperation endOperation : endOperations) {
                builder.append(endOperation.getType(), DiagramBuilderEscapeUtil.substituteReferences((String)refChainId, (ChainElement)currentElement, (String[])endOperation.getArgs()));
            }
        }
        this.toNextElements(refChainId, builder, fromElementMap, elementsTo, elementsToProcessIds, mode);
    }

    private void processElement(String refChainId, SequenceDiagramBuilder builder, ChainElement currentElement, Map<String, List<ChainElement>> fromElementMap, Set<String> elementsToProcessIds, DiagramMode mode, ElementDescriptor elementDescriptor, List<ChainElement> elementsTo, DesignProcessor designProcessor) {
        if (ElementType.REUSE_REFERENCE == elementDescriptor.getType()) {
            this.toNextElements(refChainId, builder, fromElementMap, elementsTo, elementsToProcessIds, mode);
            return;
        }
        boolean shouldWriteElement = DesignGeneratorService.shouldWriteElement((ChainElement)currentElement, (DiagramMode)mode);
        ElementDesignParameters designParameters = elementDescriptor.getDesignParameters();
        if (designParameters == null) {
            this.processElementWithDesignProcessor(refChainId, builder, currentElement, fromElementMap, elementsToProcessIds, mode, elementsTo, designProcessor, shouldWriteElement);
        } else {
            this.processElementWithDesignParams(refChainId, builder, currentElement, fromElementMap, elementsToProcessIds, mode, elementsTo, designParameters, shouldWriteElement);
        }
    }

    private void processElementWithDesignProcessor(String refChainId, SequenceDiagramBuilder builder, ChainElement currentElement, Map<String, List<ChainElement>> fromElementMap, Set<String> elementsToProcessIds, DiagramMode mode, List<ChainElement> elementsTo, DesignProcessor designProcessor, boolean shouldWriteElement) {
        if (designProcessor != null) {
            if (shouldWriteElement) {
                designProcessor.processBefore(refChainId, builder, currentElement);
                this.toNextElements(refChainId, builder, fromElementMap, elementsTo, elementsToProcessIds, mode);
                designProcessor.processAfter(refChainId, builder, currentElement);
            } else {
                this.toNextElements(refChainId, builder, fromElementMap, elementsTo, elementsToProcessIds, mode);
            }
        }
    }

    private void processElementWithDesignParams(String refChainId, SequenceDiagramBuilder builder, ChainElement currentElement, Map<String, List<ChainElement>> fromElementMap, Set<String> elementsToProcessIds, DiagramMode mode, List<ChainElement> elementsTo, ElementDesignParameters designParameters, boolean shouldWriteElement) {
        String toId;
        String fromId;
        String title = designParameters.getRequestLineTitle(refChainId, currentElement);
        if (designParameters.isDirectionToChain()) {
            fromId = designParameters.getExternalParticipantId(refChainId, currentElement);
            toId = refChainId;
        } else {
            fromId = refChainId;
            toId = designParameters.getExternalParticipantId(refChainId, currentElement);
        }
        if (shouldWriteElement) {
            builder.append(DiagramOperationType.LINE_WITH_ARROW_SOLID_RIGHT, new String[]{fromId, toId, title});
            if (designParameters.isHasResponse()) {
                builder.append(DiagramOperationType.ACTIVATE, new String[]{toId});
                if (!designParameters.isResponseAfterRequest()) {
                    this.toNextElements(refChainId, builder, fromElementMap, elementsTo, elementsToProcessIds, mode);
                }
                builder.append(DiagramOperationType.LINE_WITH_ARROW_DOTTED_RIGHT, new String[]{toId, fromId, "Response"});
                if (!designParameters.isDirectionToChain()) {
                    builder.append(DiagramOperationType.DEACTIVATE, new String[]{toId});
                }
            }
        } else if (designParameters.isHasResponse() && !designParameters.isResponseAfterRequest()) {
            this.toNextElements(refChainId, builder, fromElementMap, elementsTo, elementsToProcessIds, mode);
        }
        if (designParameters.isResponseAfterRequest()) {
            this.toNextElements(refChainId, builder, fromElementMap, elementsTo, elementsToProcessIds, mode);
        }
    }

    private void toNextElements(String refChainId, SequenceDiagramBuilder builder, Map<String, List<ChainElement>> fromElementMap, List<ChainElement> elementsTo, Set<String> elementsToProcessIds, DiagramMode mode) {
        for (ChainElement elementTo : elementsTo) {
            this.generateDiagramRecursive(refChainId, builder, elementTo, fromElementMap, elementsToProcessIds, mode);
        }
    }

    private void collectReuseDependencies(List<ChainElement> elements, Map<String, List<ChainElement>> fromElementMap) {
        Map elementMap = elements.stream().collect(Collectors.toMap(element -> element.getSnapshot() != null ? element.getOriginalId() : element.getId(), Function.identity()));
        for (ChainElement element2 : elements) {
            ChainElement reuseElement;
            ElementDescriptor descriptor = this.libraryService.getElementDescriptor(element2);
            if (ElementType.REUSE_REFERENCE != descriptor.getType() || !((reuseElement = (ChainElement)elementMap.get(element2.getPropertyAsString(descriptor.getReuseReferenceProperty()))) instanceof ContainerChainElement)) continue;
            ContainerChainElement reuseContainer = (ContainerChainElement)reuseElement;
            if (!element2.getOutputDependencies().isEmpty()) {
                fromElementMap.remove(element2.getId());
                List<ChainElement> referenceOutputElements = element2.getOutputDependencies().stream().map(Dependency::getElementTo).toList();
                reuseContainer.getElements().stream().filter(child -> child.getOutputDependencies().isEmpty()).forEach(lastElement -> fromElementMap.put(lastElement.getId(), referenceOutputElements));
            }
            fromElementMap.compute(element2.getId(), (elementFormId, elementsTo) -> {
                ArrayList<ContainerChainElement> result = new ArrayList<ContainerChainElement>(Collections.singleton(reuseContainer));
                if (elementsTo != null) {
                    elementsTo.stream().filter(elementTo -> StringUtils.equals((CharSequence)elementTo.getId(), (CharSequence)element2.getId())).forEach(result::add);
                }
                return result;
            });
        }
    }

    private static boolean shouldWriteElement(ChainElement currentElement, DiagramMode mode) {
        return mode != DiagramMode.SIMPLE || !SIMPLE_DIAGRAM_ELEMENT_EXCLUDE_SET.contains(currentElement.getType());
    }
}

