/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.service.designgenerator;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.catalog.model.designgenerator.DiagramConstants;
import org.qubership.integration.platform.catalog.model.designgenerator.DiagramLangType;
import org.qubership.integration.platform.catalog.model.designgenerator.DiagramOperation;
import org.qubership.integration.platform.catalog.model.designgenerator.DiagramOperationType;

public class SequenceDiagramBuilder {
    private final Map<DiagramLangType, StringBuilder> sources = new HashMap();

    public SequenceDiagramBuilder() {
        this(DiagramLangType.values());
    }

    public SequenceDiagramBuilder(DiagramLangType ... types) {
        for (DiagramLangType type : types) {
            this.sources.put(type, new StringBuilder());
        }
    }

    public SequenceDiagramBuilder append(DiagramOperationType operationType, String ... args) {
        for (Map.Entry entry : this.sources.entrySet()) {
            ((StringBuilder)entry.getValue()).append(this.buildOperation((DiagramLangType)entry.getKey(), operationType, args));
        }
        return this;
    }

    public Map<DiagramLangType, String> build() {
        return this.sources.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, x -> ((StringBuilder)x.getValue()).toString()));
    }

    private String buildOperation(DiagramLangType langType, DiagramOperationType operationType, String ... args) {
        DiagramOperation operation = ((Map)DiagramConstants.OPERATIONS.get(langType)).getOrDefault(operationType, DiagramConstants.EMPTY_OPERATION);
        String operationString = operation.getOperationString();
        args = operation.remapArguments(args);
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (operation.isEscapeArgument(i)) {
                arg = langType.escapeArgument(arg);
            }
            operationString = DiagramConstants.ARG_PLACEHOLDER_PATTERN.matcher(operationString).replaceFirst(arg == null ? "" : arg.replace("$", "\\$"));
        }
        return operationString + (StringUtils.isEmpty((CharSequence)operationString) ? "\n" : langType.getLineTerminator());
    }
}

