/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.service.designgenerator.processors;

import java.util.Optional;
import java.util.Set;
import org.qubership.integration.platform.catalog.model.designgenerator.DiagramOperationType;
import org.qubership.integration.platform.catalog.persistence.configs.entity.AbstractEntity;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Snapshot;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.util.DiagramBuilderEscapeUtil;
import org.qubership.integration.platform.designtime.catalog.service.ElementService;
import org.qubership.integration.platform.designtime.catalog.service.designgenerator.SequenceDiagramBuilder;
import org.qubership.integration.platform.designtime.catalog.service.designgenerator.processors.interfaces.DesignProcessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ChainCall2DesignProcessor
implements DesignProcessor {
    private final ElementService elementService;

    @Autowired
    public ChainCall2DesignProcessor(ElementService elementService) {
        this.elementService = elementService;
    }

    public Set<String> supportedElementTypes() {
        return Set.of("chain-call-2");
    }

    public String getExternalParticipantId(ChainElement element) {
        return this.getExternalParticipant(element).map(AbstractEntity::getId).map(DiagramBuilderEscapeUtil::removeOrReplaceUnsupportedCharacters).orElseGet(() -> element.getId() + "-external-participant");
    }

    public String getExternalParticipantName(ChainElement element) {
        return this.getExternalParticipant(element).map(AbstractEntity::getName).map(name -> "QIP chain: " + name).orElse("Unknown QIP chain");
    }

    public void processBefore(String refChainId, SequenceDiagramBuilder builder, ChainElement element) {
        String externalParticipantId = this.getExternalParticipantId(element);
        Optional triggerId = this.getChainTriggerId(element);
        String nameOrId = triggerId.flatMap(arg_0 -> ((ElementService)this.elementService).findByIdOptional(arg_0)).or(() -> triggerId.flatMap(arg_0 -> ((ElementService)this.elementService).findByOriginalId(arg_0))).map(AbstractEntity::getName).or(() -> triggerId).orElse(null);
        builder.append(DiagramOperationType.LINE_WITH_ARROW_SOLID_RIGHT, new String[]{refChainId, externalParticipantId, "QIP chain trigger call: " + nameOrId});
        builder.append(DiagramOperationType.ACTIVATE, new String[]{externalParticipantId});
        builder.append(DiagramOperationType.LINE_WITH_ARROW_DOTTED_RIGHT, new String[]{externalParticipantId, refChainId, "Response"});
        builder.append(DiagramOperationType.DEACTIVATE, new String[]{externalParticipantId});
    }

    public void processAfter(String refChainId, SequenceDiagramBuilder builder, ChainElement element) {
    }

    private Optional<Chain> getExternalParticipant(ChainElement element) {
        Optional triggerId = this.getChainTriggerId(element);
        Optional<Chain> chainElement = triggerId.flatMap(arg_0 -> ((ElementService)this.elementService).findByIdOptional(arg_0)).or(() -> triggerId.flatMap(arg_0 -> ((ElementService)this.elementService).findByOriginalId(arg_0)));
        return chainElement.map(ChainElement::getChain).or(() -> chainElement.map(ChainElement::getSnapshot).map(Snapshot::getChain));
    }

    private Optional<String> getChainTriggerId(ChainElement element) {
        return Optional.ofNullable(element.getPropertyAsString("elementId"));
    }
}

