/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.service.designgenerator.processors;

import java.util.Set;
import org.qubership.integration.platform.catalog.model.designgenerator.DiagramConstants;
import org.qubership.integration.platform.catalog.model.designgenerator.DiagramOperationType;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.util.DiagramBuilderEscapeUtil;
import org.qubership.integration.platform.designtime.catalog.service.designgenerator.SequenceDiagramBuilder;
import org.qubership.integration.platform.designtime.catalog.service.designgenerator.processors.interfaces.DesignProcessor;
import org.springframework.stereotype.Component;

@Component
public class CheckpointDesignProcessor
implements DesignProcessor {
    public Set<String> supportedElementTypes() {
        return Set.of("checkpoint");
    }

    public String getExternalParticipantId(ChainElement element) {
        return DiagramBuilderEscapeUtil.removeOrReplaceUnsupportedCharacters((String)this.getExternalParticipantName(element));
    }

    public String getExternalParticipantName(ChainElement element) {
        return "Unknown user";
    }

    public void processBefore(String refChainId, SequenceDiagramBuilder builder, ChainElement element) {
        String checkpointTitle = element.getName() + " with id " + element.getPropertyAsString("checkpointElementId");
        builder.append(DiagramOperationType.START_GROUP, new String[]{checkpointTitle});
        builder.append(DiagramOperationType.START_COLORED_GROUP, new String[]{DiagramConstants.GROUP_BG_RGB[0], DiagramConstants.GROUP_BG_RGB[1], DiagramConstants.GROUP_BG_RGB[2], refChainId, checkpointTitle});
        builder.append(DiagramOperationType.START_ALT, new String[]{"Trigger"});
        builder.append(DiagramOperationType.LINE_WITH_ARROW_SOLID_RIGHT, new String[]{this.getExternalParticipantId(element), refChainId, "Request to retry session"});
        builder.append(DiagramOperationType.LINE_WITH_ARROW_SOLID_RIGHT, new String[]{refChainId, refChainId, "Load context"});
        builder.append(DiagramOperationType.ELSE, new String[]{"Checkpoint"});
        builder.append(DiagramOperationType.LINE_WITH_ARROW_SOLID_RIGHT, new String[]{refChainId, refChainId, "Save context"});
        builder.append(DiagramOperationType.END, new String[0]);
        builder.append(DiagramOperationType.END, new String[0]);
    }

    public void processAfter(String refChainId, SequenceDiagramBuilder builder, ChainElement element) {
    }
}

