/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.service.designgenerator.processors;

import java.util.Comparator;
import java.util.Set;
import java.util.function.Predicate;
import org.qubership.integration.platform.catalog.model.designgenerator.DiagramOperationType;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ContainerChainElement;
import org.qubership.integration.platform.catalog.util.DiagramBuilderEscapeUtil;
import org.qubership.integration.platform.designtime.catalog.service.designgenerator.SequenceDiagramBuilder;
import org.qubership.integration.platform.designtime.catalog.service.designgenerator.processors.interfaces.ContainerDesignProcessor;
import org.springframework.stereotype.Component;
import org.springframework.util.comparator.Comparators;

@Component
public class LoopContainerDesignProcessor
implements ContainerDesignProcessor {
    public Comparator<ChainElement> getComparator() {
        return Comparators.comparable();
    }

    public Predicate<ChainElement> getChildrenFilter() {
        return element -> element.getInputDependencies().isEmpty();
    }

    public boolean isContainerWithRestrictions() {
        return false;
    }

    public Set<String> supportedElementTypes() {
        return Set.of("loop-2");
    }

    public String getExternalParticipantId(ChainElement element) {
        return null;
    }

    public String getExternalParticipantName(ChainElement element) {
        return null;
    }

    public void processBefore(String refChainId, SequenceDiagramBuilder builder, ChainElement element) {
        ContainerChainElement containerElement;
        if (element instanceof ContainerChainElement && !(containerElement = (ContainerChainElement)element).getElements().isEmpty()) {
            builder.append(DiagramOperationType.START_LOOP, new String[]{DiagramBuilderEscapeUtil.substituteProperties((String)refChainId, (ChainElement)element, (String)"##{expression}")});
        }
    }

    public void processAfter(String refChainId, SequenceDiagramBuilder builder, ChainElement element) {
        ContainerChainElement containerElement;
        if (element instanceof ContainerChainElement && !(containerElement = (ContainerChainElement)element).getElements().isEmpty()) {
            builder.append(DiagramOperationType.END, new String[0]);
        }
    }

    public void processChildAfter(String refChainId, SequenceDiagramBuilder builder, ChainElement element, ChainElement child) {
    }

    public void processChildBefore(String refChainId, SequenceDiagramBuilder builder, ChainElement element, ChainElement child) {
    }
}

