/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.service.designgenerator.processors;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.catalog.model.designgenerator.DiagramConstants;
import org.qubership.integration.platform.catalog.model.designgenerator.DiagramOperationType;
import org.qubership.integration.platform.catalog.model.system.ServiceEnvironment;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.IntegrationSystem;
import org.qubership.integration.platform.catalog.persistence.configs.repository.system.SystemRepository;
import org.qubership.integration.platform.catalog.util.DiagramBuilderEscapeUtil;
import org.qubership.integration.platform.catalog.util.ElementUtils;
import org.qubership.integration.platform.designtime.catalog.service.EnvironmentService;
import org.qubership.integration.platform.designtime.catalog.service.designgenerator.SequenceDiagramBuilder;
import org.qubership.integration.platform.designtime.catalog.service.designgenerator.processors.ServiceCallDesignProcessor;
import org.qubership.integration.platform.designtime.catalog.service.designgenerator.processors.interfaces.DesignProcessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServiceCallDesignProcessor
implements DesignProcessor {
    private final SystemRepository systemRepository;
    private final EnvironmentService environmentService;

    @Autowired
    public ServiceCallDesignProcessor(SystemRepository systemRepository, EnvironmentService environmentService) {
        this.systemRepository = systemRepository;
        this.environmentService = environmentService;
    }

    public Set<String> supportedElementTypes() {
        return Set.of("service-call");
    }

    public String getExternalParticipantId(ChainElement element) {
        IntegrationSystem system = this.getSystem(element);
        return system == null ? null : DiagramBuilderEscapeUtil.removeOrReplaceUnsupportedCharacters((String)system.getId());
    }

    public String getExternalParticipantName(ChainElement element) {
        IntegrationSystem system = this.getSystem(element);
        return system == null ? null : "Service: " + system.getName();
    }

    private IntegrationSystem getSystem(ChainElement element) {
        Map properties = element.getProperties();
        return properties.containsKey("integrationSystemId") ? (IntegrationSystem)this.systemRepository.findById((Object)((String)properties.get("integrationSystemId"))).orElseThrow(() -> new RuntimeException("Can't find system with id: " + String.valueOf(properties.get("integrationSystemId")))) : null;
    }

    public void processBefore(String refChainId, SequenceDiagramBuilder builder, ChainElement element) {
        Map properties = element.getProperties();
        Map before = (Map)properties.get("before");
        List afterList = (List)properties.get("after");
        String externalParticipantId = this.getExternalParticipantId(element);
        String protocol = (String)properties.get("integrationOperationProtocolType");
        if (externalParticipantId != null) {
            builder.append(DiagramOperationType.START_GROUP, new String[]{element.getName()});
            builder.append(DiagramOperationType.START_COLORED_GROUP, new String[]{DiagramConstants.GROUP_BG_RGB[0], DiagramConstants.GROUP_BG_RGB[1], DiagramConstants.GROUP_BG_RGB[2], refChainId, element.getName()});
            if (before != null && before.containsKey("type")) {
                builder.append(DiagramOperationType.LINE_WITH_ARROW_SOLID_RIGHT, new String[]{refChainId, refChainId, "Prepare request (" + before.get("type").toString() + ")"});
            }
            String lineMessage = this.buildPathMessage(properties, protocol);
            builder.append(DiagramOperationType.LINE_WITH_ARROW_SOLID_RIGHT, new String[]{refChainId, externalParticipantId, lineMessage});
            if ("http".equals(protocol) || "graphql".equals(protocol)) {
                builder.append(DiagramOperationType.ACTIVATE, new String[]{externalParticipantId});
                builder.append(DiagramOperationType.LINE_WITH_ARROW_DOTTED_RIGHT, new String[]{externalParticipantId, refChainId, "Response"});
                builder.append(DiagramOperationType.DEACTIVATE, new String[]{externalParticipantId});
            }
            if (afterList != null && !afterList.isEmpty()) {
                boolean atLeastOneHandler = false;
                for (Map after : afterList) {
                    if (after == null || !after.containsKey("label") || !after.containsKey("type")) continue;
                    builder.append(atLeastOneHandler ? DiagramOperationType.ELSE : DiagramOperationType.START_ALT, new String[]{"Code " + String.valueOf(after.get("label"))});
                    builder.append(DiagramOperationType.LINE_WITH_ARROW_SOLID_RIGHT, new String[]{refChainId, refChainId, "Handle response  (" + after.get("type").toString() + ")"});
                    atLeastOneHandler = true;
                }
                if (atLeastOneHandler) {
                    builder.append(DiagramOperationType.END, new String[0]);
                }
            }
            builder.append(DiagramOperationType.END, new String[0]);
        }
    }

    public void processAfter(String refChainId, SequenceDiagramBuilder builder, ChainElement element) {
    }

    private String buildPathMessage(Map<String, Object> elementProperties, String protocol) {
        switch (protocol) {
            case "amqp": {
                return "Put message to exchange " + String.valueOf(elementProperties.getOrDefault("integrationOperationPath", "%empty_property%"));
            }
            case "kafka": {
                String systemId = (String)elementProperties.get("integrationSystemId");
                if (systemId != null) {
                    List environments = this.environmentService.generateSystemEnvironments(Set.of(systemId));
                    if (environments.isEmpty()) break;
                    ServiceEnvironment env = (ServiceEnvironment)environments.get(0);
                    Map asyncProperties = ElementUtils.mergeProperties(elementProperties.getOrDefault("integrationOperationAsyncProperties", Collections.emptyMap()), (Map)env.getProperties());
                    switch (1.$SwitchMap$org$qubership$integration$platform$catalog$model$system$EnvironmentSourceType[env.getSourceType().ordinal()]) {
                        case 1: {
                            return "Put message to topic " + String.valueOf(elementProperties.getOrDefault("integrationOperationPath", "%empty_property%"));
                        }
                        case 2: {
                            return "Put message to topic by classifier " + String.valueOf(asyncProperties.getOrDefault("maas.classifier.name", "%empty_property%"));
                        }
                    }
                    break;
                }
                return "%empty_property%";
            }
            case "graphql": {
                String operationName = (String)elementProperties.get("integrationGqlOperationName");
                return "GraphQL request (query/mutation)" + (String)(StringUtils.isEmpty((CharSequence)operationName) ? "" : ", operation: " + operationName);
            }
        }
        Object method = elementProperties.get("integrationOperationMethod");
        Object path = elementProperties.get("integrationOperationPath");
        return String.valueOf(method) + " " + String.valueOf(path);
    }
}

