/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.service.filter;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Subquery;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.qubership.integration.platform.catalog.model.filter.FilterCondition;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.service.filter.FilterConditionPredicateBuilderFactory;
import org.qubership.integration.platform.designtime.catalog.model.enums.filter.FilterFeature;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.FilterRequestDTO;
import org.qubership.integration.platform.designtime.catalog.service.filter.ChainFilterSpecificationBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Component;

@Component
public class ChainFilterSpecificationBuilder {
    private static final Set<FilterFeature> ELEMENT_PARAMS_FEATURE_SET = Set.of(FilterFeature.EXCHANGE, FilterFeature.QUEUE, FilterFeature.TOPIC, FilterFeature.SERVICE_ID, FilterFeature.CLASSIFIER);
    private final FilterConditionPredicateBuilderFactory filterConditionPredicateBuilderFactory;

    @Autowired
    public ChainFilterSpecificationBuilder(FilterConditionPredicateBuilderFactory filterConditionPredicateBuilderFactory) {
        this.filterConditionPredicateBuilderFactory = filterConditionPredicateBuilderFactory;
    }

    public Specification<Chain> buildSearch(Collection<FilterRequestDTO> filters) {
        return this.build(filters, CriteriaBuilder::or, true);
    }

    public Specification<Chain> buildFilter(Collection<FilterRequestDTO> filters) {
        return this.build(filters, CriteriaBuilder::and, false);
    }

    public Specification<Chain> build(Collection<FilterRequestDTO> filters, BiFunction<CriteriaBuilder, Predicate[], Predicate> predicateAccumulator, boolean searchMode) {
        Map<FilterFeature, List<FilterRequestDTO>> filtersMap = filters.stream().collect(Collectors.groupingBy(FilterRequestDTO::getFeature));
        ArrayList<FilterRequestDTO> commonFilters = new ArrayList<FilterRequestDTO>();
        HashMap<FilterFeature, List<FilterRequestDTO>> orFilters = new HashMap<FilterFeature, List<FilterRequestDTO>>();
        for (Map.Entry<FilterFeature, List<FilterRequestDTO>> entry : filtersMap.entrySet()) {
            List<FilterRequestDTO> filterRequestDTOs = entry.getValue();
            commonFilters.addAll(filterRequestDTOs.stream().filter(dto -> dto.getCondition() == FilterCondition.IS_NOT || !ELEMENT_PARAMS_FEATURE_SET.contains(dto.getFeature())).toList());
            orFilters.put(entry.getKey(), filterRequestDTOs.stream().filter(dto -> dto.getCondition() != FilterCondition.IS_NOT && ELEMENT_PARAMS_FEATURE_SET.contains(dto.getFeature())).toList());
        }
        return this.buildComplexSpec(commonFilters, orFilters, predicateAccumulator, searchMode);
    }

    private Specification<Chain> buildComplexSpec(List<FilterRequestDTO> commonFilters, Map<FilterFeature, List<FilterRequestDTO>> orFilters, BiFunction<CriteriaBuilder, Predicate[], Predicate> predicateAccumulator, boolean searchMode) {
        return (Specification & Serializable)(root, query, criteriaBuilder) -> {
            query.distinct(true);
            ArrayList<Predicate> havingPredicates = new ArrayList<Predicate>();
            Predicate commonResult = null;
            if (!commonFilters.isEmpty()) {
                Predicate[] predicates = (Predicate[])commonFilters.stream().map(filter -> this.buildPredicate(root, criteriaBuilder, filter)).toArray(Predicate[]::new);
                commonResult = commonFilters.size() > 1 ? (Predicate)predicateAccumulator.apply(criteriaBuilder, predicates) : predicates[0];
            }
            Predicate orResult = null;
            if (!orFilters.isEmpty()) {
                if (!searchMode) {
                    Path chainIdPath = root.get("id");
                    query.groupBy(new Expression[]{chainIdPath});
                }
                ArrayList orPredicates = new ArrayList();
                for (Map.Entry entry : orFilters.entrySet()) {
                    Expression expression;
                    FilterFeature feature = (FilterFeature)entry.getKey();
                    List filterRequestDTOS = (List)entry.getValue();
                    filterRequestDTOS.stream().map(dto -> this.buildPredicate(root, criteriaBuilder, dto)).forEach(orPredicates::add);
                    if (filterRequestDTOS.isEmpty()) continue;
                    if ((expression = (switch (1.$SwitchMap$org$qubership$integration$platform$designtime$catalog$model$enums$filter$FilterFeature[feature.ordinal()]) {
                        case 11 -> criteriaBuilder.sum(criteriaBuilder.countDistinct(this.getChainElementPropertyExpression(root, criteriaBuilder, "integrationOperationPath")), criteriaBuilder.countDistinct(this.getChainElementPropertyExpression(root, criteriaBuilder, "topics")));
                        case 12 -> criteriaBuilder.sum(criteriaBuilder.countDistinct(this.getChainElementPropertyExpression(root, criteriaBuilder, "queues")), criteriaBuilder.countDistinct(this.getChainElementSubPropertyExpression(root, criteriaBuilder, "integrationOperationAsyncProperties", "queues")));
                        case 13 -> criteriaBuilder.sum(criteriaBuilder.countDistinct(this.getChainElementPropertyExpression(root, criteriaBuilder, "integrationOperationPath")), criteriaBuilder.countDistinct(this.getChainElementPropertyExpression(root, criteriaBuilder, "exchange")));
                        case 14 -> criteriaBuilder.countDistinct(this.getChainElementPropertyExpression(root, criteriaBuilder, "integrationSystemId"));
                        case 15 -> criteriaBuilder.sum(criteriaBuilder.sum(criteriaBuilder.countDistinct(this.getChainElementPropertyExpression(root, criteriaBuilder, "topicsClassifierName")), criteriaBuilder.countDistinct(this.getChainElementPropertyExpression(root, criteriaBuilder, "vhostClassifierName"))), criteriaBuilder.countDistinct(this.getChainElementSubPropertyExpression(root, criteriaBuilder, "integrationOperationAsyncProperties", "maas.classifier.name")));
                        default -> null;
                    })) == null) continue;
                    havingPredicates.add(criteriaBuilder.greaterThanOrEqualTo(expression, (Comparable)Long.valueOf(filterRequestDTOS.size())));
                }
                if (!havingPredicates.isEmpty() && !orPredicates.isEmpty()) {
                    if (!searchMode) {
                        query.having((Expression)(havingPredicates.size() > 1 ? criteriaBuilder.and((Predicate[])havingPredicates.toArray(Predicate[]::new)) : (Expression)havingPredicates.get(0)));
                    }
                    Predicate predicate = orResult = orPredicates.size() > 1 ? criteriaBuilder.or((Predicate[])orPredicates.toArray(Predicate[]::new)) : (Predicate)orPredicates.get(0);
                }
            }
            if (commonResult == null && orResult != null) {
                return orResult;
            }
            if (commonResult != null && orResult == null) {
                return commonResult;
            }
            if (commonResult != null && orResult != null) {
                return (Predicate)predicateAccumulator.apply(criteriaBuilder, new Predicate[]{commonResult, orResult});
            }
            return null;
        };
    }

    private Predicate buildPredicate(Root<Chain> root, CriteriaBuilder criteriaBuilder, FilterRequestDTO filter) {
        boolean isNegativeElementFilter = (filter.getCondition() == FilterCondition.IS_NOT || filter.getCondition() == FilterCondition.NOT_IN) && ELEMENT_PARAMS_FEATURE_SET.contains(filter.getFeature());
        BiFunction conditionPredicateBuilder = this.filterConditionPredicateBuilderFactory.getPredicateBuilder(criteriaBuilder, filter.getCondition());
        String value = filter.getValue();
        return switch (1.$SwitchMap$org$qubership$integration$platform$designtime$catalog$model$enums$filter$FilterFeature[filter.getFeature().ordinal()]) {
            case 1 -> (Predicate)conditionPredicateBuilder.apply(root.get("id"), value);
            case 2 -> (Predicate)conditionPredicateBuilder.apply(root.get("name"), value);
            case 3 -> (Predicate)conditionPredicateBuilder.apply(root.get("description"), value);
            case 4 -> (Predicate)conditionPredicateBuilder.apply(this.getDeploymentPropertyExpression(root, "domain"), value);
            case 5, 6, 7 -> criteriaBuilder.conjunction();
            case 8 -> criteriaBuilder.or(new Predicate[]{criteriaBuilder.and((Expression)this.elementTypeIs(root, criteriaBuilder, "http-trigger"), (Expression)criteriaBuilder.or((Expression)conditionPredicateBuilder.apply(this.getChainElementPropertyExpression(root, criteriaBuilder, "integrationOperationPath"), value), (Expression)conditionPredicateBuilder.apply(this.getChainElementPropertyExpression(root, criteriaBuilder, "contextPath"), value))), criteriaBuilder.and(new Predicate[]{this.elementTypeIs(root, criteriaBuilder, "service-call"), criteriaBuilder.equal(this.getChainElementPropertyExpression(root, criteriaBuilder, "integrationOperationProtocolType"), (Object)"http"), (Predicate)conditionPredicateBuilder.apply(this.getChainElementPropertyExpression(root, criteriaBuilder, "integrationOperationPath"), value)}), criteriaBuilder.and((Expression)this.elementTypeIs(root, criteriaBuilder, "http-sender"), (Expression)conditionPredicateBuilder.apply(criteriaBuilder.function("regexp_replace", String.class, new Expression[]{this.getChainElementPropertyExpression(root, criteriaBuilder, "uri"), criteriaBuilder.literal((Object)"^https?://[^:/]+(:\\d{1,5})?"), criteriaBuilder.literal((Object)"")}), value))});
            case 9 -> criteriaBuilder.or(new Predicate[]{criteriaBuilder.and((Expression)this.elementTypeIs(root, criteriaBuilder, "http-sender"), (Expression)conditionPredicateBuilder.apply(this.getChainElementPropertyExpression(root, criteriaBuilder, "httpMethod"), value)), criteriaBuilder.and(new Predicate[]{this.elementTypeIs(root, criteriaBuilder, "service-call"), criteriaBuilder.equal(this.getChainElementPropertyExpression(root, criteriaBuilder, "integrationOperationProtocolType"), (Object)"http"), (Predicate)conditionPredicateBuilder.apply(this.getChainElementPropertyExpression(root, criteriaBuilder, "integrationOperationMethod"), value)}), criteriaBuilder.and((Expression)this.elementTypeIs(root, criteriaBuilder, "http-trigger"), (Expression)this.buildPredicateForHttpTriggerMethod(root, criteriaBuilder, filter.getCondition(), value))});
            case 10 -> {
                boolean negativeLabelFilter;
                Predicate predicate = (Predicate)conditionPredicateBuilder.apply(this.getJoin(root, "labels").get("name"), value);
                boolean v1 = negativeLabelFilter = filter.getCondition() == FilterCondition.IS_NOT || filter.getCondition() == FilterCondition.DOES_NOT_CONTAIN;
                if (negativeLabelFilter) {
                    yield criteriaBuilder.or((Expression)predicate, (Expression)criteriaBuilder.isNull((Expression)this.getJoin(root, "labels").get("name")));
                }
                yield predicate;
            }
            case 11 -> {
                Function<Root, Predicate> basePredicateFunc = elRoot -> criteriaBuilder.or((Expression)this.buildAsyncOperationPredicate(root, elRoot, criteriaBuilder, conditionPredicateBuilder, "kafka", "integrationOperationPath", value), (Expression)(isNegativeElementFilter ? criteriaBuilder.equal(this.getElementPropertyExpression((Expression)elRoot.get("properties"), criteriaBuilder, "topics"), (Object)value) : (Expression)conditionPredicateBuilder.apply(this.getChainElementPropertyExpression(root, criteriaBuilder, "topics"), value)));
                if (isNegativeElementFilter) {
                    yield this.getNegativeFilterPredicate(root, criteriaBuilder, basePredicateFunc);
                }
                yield basePredicateFunc.apply(null);
            }
            case 12 -> {
                Function<Root, Predicate> basePredicateFunc = elRoot -> criteriaBuilder.or((Expression)this.buildAsyncOperationPredicate(root, elRoot, criteriaBuilder, conditionPredicateBuilder, "amqp", "queues", value), (Expression)(isNegativeElementFilter ? criteriaBuilder.equal(this.getElementPropertyExpression((Expression)elRoot.get("properties"), criteriaBuilder, "queues"), (Object)value) : (Expression)conditionPredicateBuilder.apply(this.getChainElementPropertyExpression(root, criteriaBuilder, "queues"), value)));
                if (isNegativeElementFilter) {
                    yield this.getNegativeFilterPredicate(root, criteriaBuilder, basePredicateFunc);
                }
                yield basePredicateFunc.apply(null);
            }
            case 13 -> {
                Function<Root, Predicate> basePredicateFunc = elRoot -> criteriaBuilder.or((Expression)this.buildAsyncOperationPredicate(root, elRoot, criteriaBuilder, conditionPredicateBuilder, "amqp", "integrationOperationPath", value), (Expression)(isNegativeElementFilter ? criteriaBuilder.equal(this.getElementPropertyExpression((Expression)elRoot.get("properties"), criteriaBuilder, "exchange"), (Object)value) : (Expression)conditionPredicateBuilder.apply(this.getChainElementPropertyExpression(root, criteriaBuilder, "exchange"), value)));
                if (isNegativeElementFilter) {
                    yield this.getNegativeFilterPredicate(root, criteriaBuilder, basePredicateFunc);
                }
                yield basePredicateFunc.apply(null);
            }
            case 14 -> (Predicate)conditionPredicateBuilder.apply(this.getChainElementPropertyExpression(root, criteriaBuilder, "integrationSystemId"), value);
            case 15 -> {
                Function<Root, Predicate> basePredicateFunc = elRoot -> criteriaBuilder.or(new Predicate[]{this.buildAsyncOperationPredicate(root, elRoot, criteriaBuilder, conditionPredicateBuilder, "kafka", "maas.classifier.name", value), this.buildAsyncOperationPredicate(root, elRoot, criteriaBuilder, conditionPredicateBuilder, "amqp", "maas.classifier.name", value), isNegativeElementFilter ? criteriaBuilder.or((Expression)criteriaBuilder.equal(this.getChainElementPropertyExpression(root, criteriaBuilder, "topicsClassifierName"), (Object)value), (Expression)criteriaBuilder.equal(this.getChainElementPropertyExpression(root, criteriaBuilder, "vhostClassifierName"), (Object)value)) : criteriaBuilder.or((Expression)conditionPredicateBuilder.apply(this.getChainElementPropertyExpression(root, criteriaBuilder, "topicsClassifierName"), value), (Expression)conditionPredicateBuilder.apply(this.getChainElementPropertyExpression(root, criteriaBuilder, "vhostClassifierName"), value))});
                if (isNegativeElementFilter) {
                    yield this.getNegativeFilterPredicate(root, criteriaBuilder, basePredicateFunc);
                }
                yield basePredicateFunc.apply(null);
            }
            default -> throw new IllegalStateException("Unexpected filter feature: " + String.valueOf(filter.getFeature()));
        };
    }

    @NotNull
    private Predicate getNegativeFilterPredicate(Root<Chain> root, CriteriaBuilder criteriaBuilder, Function<Root<ChainElement>, Predicate> basePredicateFunc) {
        Subquery negativeSubquery = criteriaBuilder.createQuery().subquery(String.class);
        Root elRoot = negativeSubquery.from(ChainElement.class);
        negativeSubquery.select((Expression)elRoot.get("chain").get("id")).where((Expression)criteriaBuilder.and((Expression)basePredicateFunc.apply((Root<ChainElement>)elRoot), (Expression)criteriaBuilder.isNotNull((Expression)elRoot.get("chain").get("id"))));
        return criteriaBuilder.not((Expression)root.get("id").in(new Expression[]{negativeSubquery}));
    }

    private Predicate buildPredicateForHttpTriggerMethod(Root<Chain> root, CriteriaBuilder criteriaBuilder, FilterCondition condition, String value) {
        Expression methodPropertyExpression = this.getChainElementPropertyExpression(root, criteriaBuilder, "httpMethodRestrict");
        Predicate likeValue = criteriaBuilder.like(criteriaBuilder.lower(methodPropertyExpression), criteriaBuilder.lower(criteriaBuilder.literal((Object)("%" + value + "%"))));
        return switch (1.$SwitchMap$org$qubership$integration$platform$catalog$model$filter$FilterCondition[condition.ordinal()]) {
            case 1, 2, 3 -> likeValue;
            case 4, 5, 6 -> criteriaBuilder.not((Expression)likeValue);
            case 7 -> criteriaBuilder.like(criteriaBuilder.lower(methodPropertyExpression), criteriaBuilder.lower(criteriaBuilder.literal((Object)(value + "%"))));
            case 8 -> criteriaBuilder.like(criteriaBuilder.lower(methodPropertyExpression), criteriaBuilder.lower(criteriaBuilder.literal((Object)("%" + value))));
            case 9 -> criteriaBuilder.or((Expression)criteriaBuilder.literal((Object)value).isNull(), (Expression)criteriaBuilder.equal(criteriaBuilder.literal((Object)value), (Object)""));
            case 10 -> criteriaBuilder.or((Expression)criteriaBuilder.literal((Object)value).isNotNull(), (Expression)criteriaBuilder.notEqual(criteriaBuilder.literal((Object)value), (Object)""));
            default -> throw new IllegalStateException("Unexpected condition value: " + String.valueOf(condition));
        };
    }

    private Predicate buildAsyncOperationPredicate(Root<Chain> root, Root<ChainElement> elRoot, CriteriaBuilder criteriaBuilder, BiFunction<Expression<String>, String, Predicate> conditionPredicateBuilder, String protocol, String operationProperty, String value) {
        return criteriaBuilder.and(new Predicate[]{criteriaBuilder.or((Expression)this.elementTypeIs(root, criteriaBuilder, "service-call"), (Expression)this.elementTypeIs(root, criteriaBuilder, "async-api-trigger")), criteriaBuilder.equal(this.getChainElementPropertyExpression(root, criteriaBuilder, "integrationOperationProtocolType"), (Object)protocol), elRoot == null ? criteriaBuilder.or((Expression)conditionPredicateBuilder.apply((Expression<String>)this.getChainElementSubPropertyExpression(root, criteriaBuilder, "integrationOperationAsyncProperties", operationProperty), value), (Expression)conditionPredicateBuilder.apply((Expression<String>)this.getChainElementPropertyExpression(root, criteriaBuilder, operationProperty), value)) : criteriaBuilder.or((Expression)criteriaBuilder.equal(this.getChainElementSubPropertyExpression(root, criteriaBuilder, "integrationOperationAsyncProperties", operationProperty), (Object)value), (Expression)criteriaBuilder.equal(this.getChainElementPropertyExpression(root, criteriaBuilder, operationProperty), (Object)value))});
    }

    private Predicate elementTypeIs(Root<Chain> root, CriteriaBuilder criteriaBuilder, String typeName) {
        Join elementJoin = this.getJoin(root, "elements");
        return criteriaBuilder.equal((Expression)elementJoin.get("type"), (Object)typeName);
    }

    private Expression<String> getChainElementPropertyExpression(Root<Chain> root, CriteriaBuilder criteriaBuilder, String propertyName) {
        Join elementJoin = this.getJoin(root, "elements");
        return this.getElementPropertyExpression((Expression)elementJoin.get("properties"), criteriaBuilder, propertyName);
    }

    private Expression<String> getChainElementSubPropertyExpression(Root<Chain> root, CriteriaBuilder criteriaBuilder, String propertyName, String subPropertyName) {
        Join elementJoin = this.getJoin(root, "elements");
        return this.getElementPropertySubParameterExpression((Expression)elementJoin.get("properties"), criteriaBuilder, propertyName, subPropertyName);
    }

    private Expression<String> getElementPropertyExpression(Expression<?> props, CriteriaBuilder criteriaBuilder, String propertyName) {
        return criteriaBuilder.function("jsonb_extract_path_text", String.class, new Expression[]{props, criteriaBuilder.literal((Object)propertyName)});
    }

    private Expression<String> getElementPropertySubParameterExpression(Expression<?> props, CriteriaBuilder criteriaBuilder, String propertyName, String subPropertyName) {
        return criteriaBuilder.function("jsonb_extract_path_text", String.class, new Expression[]{props, criteriaBuilder.literal((Object)propertyName), criteriaBuilder.literal((Object)subPropertyName)});
    }

    private <T> Expression<T> getDeploymentPropertyExpression(Root<Chain> root, String propertyName) {
        Join deploymentJoin = this.getJoin(root, "deployments");
        return deploymentJoin.get(propertyName);
    }

    private Join<Chain, ?> getJoin(Root<Chain> root, String attributeName) {
        return root.getJoins().stream().filter(join -> join.getAttribute().getName().equals(attributeName)).findAny().orElseGet(() -> root.join(attributeName, JoinType.LEFT));
    }
}

