/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.service.filter;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.qubership.integration.platform.catalog.model.filter.FilterCondition;
import org.qubership.integration.platform.catalog.model.system.OperationProtocol;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.IntegrationSystem;
import org.qubership.integration.platform.catalog.service.filter.FilterConditionPredicateBuilderFactory;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.FilterRequestDTO;
import org.qubership.integration.platform.designtime.catalog.service.filter.SystemFilterSpecificationBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Component;

@Component
public class SystemFilterSpecificationBuilder {
    private final FilterConditionPredicateBuilderFactory filterConditionPredicateBuilderFactory;

    @Autowired
    public SystemFilterSpecificationBuilder(FilterConditionPredicateBuilderFactory filterConditionPredicateBuilderFactory) {
        this.filterConditionPredicateBuilderFactory = filterConditionPredicateBuilderFactory;
    }

    public Specification<IntegrationSystem> buildFilter(Collection<FilterRequestDTO> filters) {
        return this.build(filters, CriteriaBuilder::and);
    }

    public Specification<IntegrationSystem> build(Collection<FilterRequestDTO> filters, BiFunction<CriteriaBuilder, Predicate[], Predicate> predicateAccumulator) {
        return (Specification & Serializable)(root, query, criteriaBuilder) -> {
            query.distinct(true);
            Predicate commonResult = null;
            if (!filters.isEmpty()) {
                Predicate[] predicates = (Predicate[])filters.stream().map(filter -> this.buildPredicate(root, criteriaBuilder, filter)).toArray(Predicate[]::new);
                commonResult = filters.size() > 1 ? (Predicate)predicateAccumulator.apply(criteriaBuilder, predicates) : predicates[0];
            }
            return commonResult;
        };
    }

    private Predicate buildPredicate(Root<IntegrationSystem> root, CriteriaBuilder criteriaBuilder, FilterRequestDTO filter) {
        BiFunction conditionPredicateBuilder = this.filterConditionPredicateBuilderFactory.getPredicateBuilder(criteriaBuilder, filter.getCondition());
        String value = filter.getValue();
        return switch (1.$SwitchMap$org$qubership$integration$platform$designtime$catalog$model$enums$filter$FilterFeature[filter.getFeature().ordinal()]) {
            case 1 -> (Predicate)conditionPredicateBuilder.apply(root.get("id"), value);
            case 2 -> (Predicate)conditionPredicateBuilder.apply(root.get("name"), value);
            case 3 -> (Predicate)conditionPredicateBuilder.apply(root.join("specificationGroups").get("name"), value);
            case 4 -> (Predicate)conditionPredicateBuilder.apply(root.join("specificationGroups").join("systemModels").get("version"), value);
            case 5 -> (Predicate)conditionPredicateBuilder.apply(root.join("specificationGroups").join("systemModels").join("operations").get("path"), value);
            case 6 -> (Predicate)conditionPredicateBuilder.apply(root.get("protocol"), this.convertProtocols(value));
            case 7 -> (Predicate)conditionPredicateBuilder.apply(root.get("createdWhen"), value);
            case 8 -> {
                boolean negativeLabelFilter;
                Predicate predicate = (Predicate)conditionPredicateBuilder.apply(this.getJoin(root, "labels").get("name"), value);
                boolean v1 = negativeLabelFilter = filter.getCondition() == FilterCondition.IS_NOT || filter.getCondition() == FilterCondition.DOES_NOT_CONTAIN;
                if (negativeLabelFilter) {
                    yield criteriaBuilder.or((Expression)predicate, (Expression)criteriaBuilder.isNull((Expression)this.getJoin(root, "labels").get("name")));
                }
                yield predicate;
            }
            default -> throw new IllegalStateException("Unexpected feature value: " + String.valueOf(filter.getFeature()));
        };
    }

    private String convertProtocols(String value) {
        return Arrays.stream(String.valueOf(value).split(",")).map(protocol -> "," + OperationProtocol.fromValue((String)protocol).getValue()).collect(Collectors.joining()).replaceFirst(",", "");
    }

    private Join<IntegrationSystem, ?> getJoin(Root<IntegrationSystem> root, String attributeName) {
        return root.getJoins().stream().filter(join -> join.getAttribute().getName().equals(attributeName)).findAny().orElseGet(() -> root.join(attributeName, JoinType.LEFT));
    }
}

