/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.service.filter.complex;

import java.util.Arrays;
import java.util.List;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.designtime.catalog.model.enums.filter.FilterFeature;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.FilterRequestDTO;
import org.qubership.integration.platform.designtime.catalog.service.filter.complex.ElementFilter;
import org.qubership.integration.platform.designtime.catalog.service.filter.complex.FilterApplier;

public class ElementFilter
implements FilterApplier {
    public List<Chain> apply(List<Chain> chains, List<FilterRequestDTO> filters) {
        List<FilterRequestDTO> elementFilters = filters.stream().filter(filter -> filter.getFeature() == FilterFeature.ELEMENT).toList();
        if (elementFilters.isEmpty()) {
            return chains;
        }
        return chains.stream().filter(chain -> elementFilters.stream().allMatch(filter -> this.getPredicate(filter, chain.getElements()))).toList();
    }

    private boolean getPredicate(FilterRequestDTO filter, List<ChainElement> elements) {
        return switch (1.$SwitchMap$org$qubership$integration$platform$catalog$model$filter$FilterCondition[filter.getCondition().ordinal()]) {
            case 1 -> elements.stream().anyMatch(element -> Arrays.asList(filter.getValue().split(",")).contains(element.getType()));
            case 2 -> elements.stream().noneMatch(element -> Arrays.asList(filter.getValue().split(",")).contains(element.getType()));
            default -> throw new IllegalStateException("Unexpected filter value: " + String.valueOf(filter.getCondition()));
        };
    }
}

