/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.service.filter.complex;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.qubership.integration.platform.catalog.model.chain.SessionsLoggingLevel;
import org.qubership.integration.platform.catalog.model.deployment.properties.DeploymentRuntimeProperties;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.designtime.catalog.model.enums.filter.FilterFeature;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.FilterRequestDTO;
import org.qubership.integration.platform.designtime.catalog.service.ChainRuntimePropertiesService;
import org.qubership.integration.platform.designtime.catalog.service.filter.complex.FilterApplier;
import org.qubership.integration.platform.designtime.catalog.service.filter.complex.LoggingFilter;

public class LoggingFilter
implements FilterApplier {
    private final ChainRuntimePropertiesService chainRuntimePropertiesService;

    public LoggingFilter(ChainRuntimePropertiesService chainRuntimePropertiesService) {
        this.chainRuntimePropertiesService = chainRuntimePropertiesService;
    }

    public List<Chain> apply(List<Chain> chains, List<FilterRequestDTO> filters) {
        List<FilterRequestDTO> loggingFilters = filters.stream().filter(filter -> filter.getFeature() == FilterFeature.LOGGING).toList();
        if (loggingFilters.isEmpty()) {
            return chains;
        }
        Map runtimePropertiesMap = this.chainRuntimePropertiesService.getRuntimePropertiesCache();
        return chains.stream().filter(chain -> loggingFilters.stream().allMatch(filter -> this.chainMatchLoggingFilter(runtimePropertiesMap, chain, filter))).toList();
    }

    private boolean chainMatchLoggingFilter(Map<String, DeploymentRuntimeProperties> runtimePropertiesMap, Chain chain, FilterRequestDTO chainFilter) {
        DeploymentRuntimeProperties props = runtimePropertiesMap.get(chain.getId());
        return props != null && this.getSessionsLoggingLevelPredicate(chainFilter, props.getSessionsLoggingLevel());
    }

    private boolean getSessionsLoggingLevelPredicate(FilterRequestDTO filter, SessionsLoggingLevel loggingLevel) {
        return switch (1.$SwitchMap$org$qubership$integration$platform$catalog$model$filter$FilterCondition[filter.getCondition().ordinal()]) {
            case 1 -> Arrays.stream(filter.getValue().split(",")).anyMatch(value -> SessionsLoggingLevel.valueOf((String)value.toUpperCase()) == loggingLevel);
            case 2 -> Arrays.stream(filter.getValue().split(",")).noneMatch(value -> SessionsLoggingLevel.valueOf((String)value.toUpperCase()) == loggingLevel);
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(filter.getCondition()));
        };
    }
}

