/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.service.mapping;

import java.sql.Timestamp;
import org.qubership.integration.platform.catalog.model.system.ServiceEnvironment;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.Environment;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.IntegrationSystem;
import org.qubership.integration.platform.catalog.util.MapperUtils;
import org.qubership.integration.platform.designtime.catalog.service.mapping.ServiceEnvironmentMapper;
import org.springframework.stereotype.Component;

@Component
public class ServiceEnvironmentMapperImpl
extends ServiceEnvironmentMapper {
    public ServiceEnvironment toServiceEnvironment(Environment environment) {
        if (environment == null) {
            return null;
        }
        ServiceEnvironment serviceEnvironment = new ServiceEnvironment();
        serviceEnvironment.setSystemId(this.environmentSystemId(environment));
        serviceEnvironment.setId(environment.getId());
        serviceEnvironment.setSourceType(environment.getSourceType());
        serviceEnvironment.setName(environment.getName());
        serviceEnvironment.setDescription(environment.getDescription());
        serviceEnvironment.setAddress(environment.getAddress());
        serviceEnvironment.setProperties(this.jsonNodeToMap(environment.getProperties()));
        serviceEnvironment.setCreatedWhen(MapperUtils.fromTimestamp((Timestamp)environment.getCreatedWhen()));
        serviceEnvironment.setModifiedWhen(MapperUtils.fromTimestamp((Timestamp)environment.getModifiedWhen()));
        return serviceEnvironment;
    }

    private String environmentSystemId(Environment environment) {
        if (environment == null) {
            return null;
        }
        IntegrationSystem system = environment.getSystem();
        if (system == null) {
            return null;
        }
        String id = system.getId();
        if (id == null) {
            return null;
        }
        return id;
    }
}

