/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.service.migration;

import jakarta.persistence.EntityNotFoundException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.ActionLog;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.EntityType;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.LogOperation;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Dependency;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.repository.chain.ChainRepository;
import org.qubership.integration.platform.catalog.persistence.configs.repository.chain.DependencyRepository;
import org.qubership.integration.platform.catalog.persistence.configs.repository.chain.ElementRepository;
import org.qubership.integration.platform.catalog.service.ActionsLogService;
import org.qubership.integration.platform.catalog.util.DistinctByKey;
import org.qubership.integration.platform.designtime.catalog.configuration.aspect.ChainModification;
import org.qubership.integration.platform.designtime.catalog.exception.exceptions.ChainMigrationException;
import org.qubership.integration.platform.designtime.catalog.service.migration.MigratedChain;
import org.qubership.integration.platform.designtime.catalog.service.migration.element.ElementMigration;
import org.qubership.integration.platform.designtime.catalog.service.migration.element.MigrationContext;
import org.qubership.integration.platform.designtime.catalog.service.migration.element.RestrictedContainerMigration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.auditing.AuditingHandler;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ChainMigrationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ChainMigrationService.class);
    private static final String CONTAINING_SWIMLANES_ERROR_MESSAGE = "Chain containing swimlanes cannot be migrated.";
    private static final String CHAIN_WITH_ID_NOT_FOUND_MESSAGE = "Can't find chain with id: ";
    private final ActionsLogService actionLogger;
    private final AuditingHandler auditingHandler;
    private final ChainRepository chainRepository;
    private final ElementRepository elementRepository;
    private final DependencyRepository dependencyRepository;
    private final Map<String, ElementMigration> elementMigrations;

    @Autowired
    public ChainMigrationService(ActionsLogService actionLogger, AuditingHandler auditingHandler, ChainRepository chainRepository, ElementRepository elementRepository, DependencyRepository dependencyRepository, List<ElementMigration> elementMigrations) {
        this.actionLogger = actionLogger;
        this.auditingHandler = auditingHandler;
        this.chainRepository = chainRepository;
        this.elementRepository = elementRepository;
        this.elementMigrations = elementMigrations.stream().collect(Collectors.toMap(ElementMigration::getOldElementType, Function.identity()));
        this.dependencyRepository = dependencyRepository;
    }

    public boolean containsDeprecatedContainers(Chain chain) {
        return chain.getElements().stream().map(ChainElement::getType).anyMatch(this.elementMigrations::containsKey);
    }

    @Transactional
    @ChainModification
    public MigratedChain migrateChain(String chainId) {
        MigrationContext context = new MigrationContext(this.elementMigrations);
        Chain chainToMigrate = (Chain)this.chainRepository.findById((Object)chainId).orElseThrow(() -> new EntityNotFoundException(CHAIN_WITH_ID_NOT_FOUND_MESSAGE + chainId));
        Chain migratedChain = this.getMigratedChain(chainToMigrate, context);
        migratedChain.getDependencies().forEach(arg_0 -> ((DependencyRepository)this.dependencyRepository).persist(arg_0));
        migratedChain.getElements().forEach(arg_0 -> ((ElementRepository)this.elementRepository).persist(arg_0));
        this.chainRepository.saveEntity((Object)migratedChain);
        this.auditingHandler.markModified((Object)migratedChain);
        this.logChainAction(migratedChain, LogOperation.UPDATE);
        this.chainRepository.clearContext();
        migratedChain = (Chain)this.chainRepository.findById((Object)chainId).orElseThrow(() -> new EntityNotFoundException(CHAIN_WITH_ID_NOT_FOUND_MESSAGE + chainId));
        boolean groupsRemoved = !context.getGroupsToDelete().isEmpty();
        return new MigratedChain(migratedChain, groupsRemoved);
    }

    public Chain getMigratedChain(Chain chain, MigrationContext context) {
        if (chain.getDefaultSwimlane() != null || chain.getReuseSwimlane() != null) {
            throw new ChainMigrationException(CONTAINING_SWIMLANES_ERROR_MESSAGE);
        }
        chain.getDependencies().forEach(arg_0 -> ((DependencyRepository)this.dependencyRepository).remove(arg_0));
        chain.getElements().forEach(arg_0 -> ((ElementRepository)this.elementRepository).remove(arg_0));
        Map startDeprecatedElements = this.collectStartDeprecatedContainers(chain.getElements());
        if (!this.canBeMigrated(startDeprecatedElements, context)) {
            throw new ChainMigrationException(this.getErrorMessage(chain.getId()));
        }
        try {
            for (Map.Entry pair : startDeprecatedElements.entrySet()) {
                ChainElement startDeprecatedElement = (ChainElement)pair.getKey();
                ElementMigration elementMigration = (ElementMigration)pair.getValue();
                if (!elementMigration.getOldElementType().equals(startDeprecatedElement.getType())) continue;
                elementMigration.migrate(startDeprecatedElement, context);
            }
            chain.removeElements((Collection)context.getElementsToDelete());
            List rootElements = chain.getRootElements();
            chain.getElements().clear();
            chain.addElementsHierarchy((Collection)rootElements);
            return chain;
        }
        catch (Exception exception) {
            String errorMessage = this.getErrorMessage(chain.getId());
            log.error(errorMessage, (Throwable)exception);
            throw new ChainMigrationException(errorMessage, (Throwable)exception);
        }
    }

    private boolean canBeMigrated(Map<ChainElement, ElementMigration> startDeprecatedElements, MigrationContext context) {
        for (Map.Entry<ChainElement, ElementMigration> pair : startDeprecatedElements.entrySet()) {
            ChainElement startDeprecatedElement = pair.getKey();
            ElementMigration elementMigration = pair.getValue();
            if (elementMigration.canBeMigrated(startDeprecatedElement, context)) continue;
            return false;
        }
        return true;
    }

    private Map<ChainElement, ElementMigration> collectStartDeprecatedContainers(List<ChainElement> chainElements) {
        List<ChainElement> startElements = chainElements.stream().filter(chainElement -> chainElement.getParent() == null || "container".equals(chainElement.getParent().getType())).filter(chainElement -> chainElement.getInputDependencies().isEmpty()).filter(chainElement -> !"container".equals(chainElement.getType())).toList();
        Map<ChainElement, ElementMigration> startDeprecatedContainers = this.toStartDeprecatedContainerStream(startElements).filter(DistinctByKey.newInstance(Pair::getKey)).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        chainElements.stream().filter(element -> this.elementMigrations.get(element.getType()) instanceof RestrictedContainerMigration).filter(element -> !startDeprecatedContainers.containsKey(element) && (element.getInputDependencies().isEmpty() || this.hasOnlyCircularDependenciesOnItself(element))).map(element -> Pair.of((Object)element, (Object)((ElementMigration)this.elementMigrations.get(element.getType())))).forEach(elementMigrationPair -> startDeprecatedContainers.put((ChainElement)elementMigrationPair.getKey(), (ElementMigration)elementMigrationPair.getValue()));
        return startDeprecatedContainers;
    }

    private Stream<Pair<ChainElement, ElementMigration>> toStartDeprecatedContainerStream(List<ChainElement> chainElements) {
        return chainElements.stream().flatMap(startElement -> {
            ElementMigration elementMigration = (ElementMigration)this.elementMigrations.get(startElement.getType());
            if (elementMigration == null) {
                List<ChainElement> outputElements = startElement.getOutputDependencies().stream().map(Dependency::getElementTo).toList();
                return this.toStartDeprecatedContainerStream(outputElements);
            }
            return Stream.of(Pair.of((Object)startElement, (Object)elementMigration));
        });
    }

    private boolean hasOnlyCircularDependenciesOnItself(ChainElement chainElement) {
        block0: for (Dependency inputDependency : chainElement.getInputDependencies()) {
            LinkedList<ChainElement> inputElements = new LinkedList<ChainElement>();
            inputElements.offer(inputDependency.getElementFrom());
            while (!inputElements.isEmpty()) {
                ChainElement inputElement = (ChainElement)inputElements.poll();
                if (inputElement.getParent() != null && chainElement.getId().equals(inputElement.getParent().getId())) continue block0;
                inputElement.getInputDependencies().forEach(dependency -> inputElements.offer(dependency.getElementFrom()));
            }
            return false;
        }
        return true;
    }

    private String getErrorMessage(String chainId) {
        return "Chain " + chainId + " cannot be migrated.";
    }

    private void logChainAction(Chain chain, LogOperation operation) {
        this.actionLogger.logAction(ActionLog.builder().entityType(EntityType.CHAIN).entityId(chain.getId()).entityName(chain.getName()).parentType(chain.getParentFolder() == null ? null : EntityType.FOLDER).parentId(chain.getParentFolder() == null ? null : chain.getParentFolder().getId()).parentName(chain.getParentFolder() == null ? null : chain.getParentFolder().getName()).operation(operation).build());
    }
}

