/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.service.migration.element;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Dependency;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ContainerChainElement;
import org.qubership.integration.platform.catalog.service.library.LibraryElementsService;
import org.qubership.integration.platform.designtime.catalog.service.migration.element.MigrationContext;

public abstract class ElementMigration {
    protected final LibraryElementsService libraryService;
    protected final String oldElementType;
    protected final String newElementType;

    protected ElementMigration(LibraryElementsService libraryService, String oldElementType, String newElementType) {
        this.libraryService = libraryService;
        this.oldElementType = oldElementType;
        this.newElementType = newElementType;
    }

    public abstract boolean canBeMigrated(ChainElement var1, MigrationContext var2);

    public abstract ChainElement migrate(ChainElement var1, MigrationContext var2);

    public String getOldElementType() {
        return this.oldElementType;
    }

    public String getNewElementType() {
        return this.newElementType;
    }

    protected void migrateNextElements(ChainElement chainElement, MigrationContext context) {
        for (Dependency outputDependency : chainElement.getOutputDependencies()) {
            ChainElement elementTo = outputDependency.getElementTo();
            Optional.ofNullable(chainElement.getParent()).filter(parent -> !"container".equals(parent.getType()) && !parent.getElements().contains(elementTo)).ifPresent(parent -> parent.addChildElement(elementTo));
            ElementMigration elementMigration = context.getElementMigration(elementTo.getType());
            if (elementMigration != null) {
                elementMigration.migrate(elementTo, context);
                continue;
            }
            this.migrateNextElements(elementTo, context);
        }
    }

    protected List<ChainElement> collectChildren(ChainElement chainElement, MigrationContext context) {
        ArrayList<ChainElement> children = new ArrayList<ChainElement>();
        for (Dependency outputDependency : new ArrayList(chainElement.getOutputDependencies())) {
            ChainElement elementTo = outputDependency.getElementTo();
            if (elementTo.getInputDependencies().size() > 1 || context.getReuseElements().containsKey(elementTo.getId()) || context.isElementMigrationInProgress(elementTo)) {
                this.removeElementFromParentGroupIfRequired(elementTo, context);
                children.add(this.replaceReusedElementWithReference(chainElement, elementTo, context));
                if (elementTo.getInputDependencies().isEmpty()) continue;
                for (Dependency inputDependency : new ArrayList(elementTo.getInputDependencies())) {
                    if (context.isReferenceInputInProgress(inputDependency.getElementFrom())) continue;
                    ChainElement referenceElement = this.replaceReusedElementWithReference(inputDependency.getElementFrom(), inputDependency.getElementTo(), context);
                    elementTo.getChain().addElement(referenceElement);
                }
                continue;
            }
            ElementMigration elementMigration = context.getElementMigration(elementTo.getType());
            if (elementMigration != null) {
                children.add(elementMigration.migrate(elementTo, context));
            } else {
                children.add(elementTo);
            }
            children.addAll(this.collectChildren(elementTo, context));
        }
        children.forEach(child -> this.removeElementFromParentGroupIfRequired(child, context));
        return children;
    }

    protected ChainElement replaceReusedElementWithReference(ChainElement elementFrom, ChainElement elementTo, MigrationContext context) {
        context.getInProgressReferenceInputIds().add(elementFrom.getId());
        ElementMigration reuseElementMigration = context.getElementMigration("reused-element");
        if (reuseElementMigration == null) {
            throw new IllegalArgumentException("Reused elements cannot be migrated");
        }
        ChainElement referenceElement = reuseElementMigration.migrate(elementTo, context);
        elementTo.getInputDependencies().removeIf(dependency -> {
            if (StringUtils.equals((CharSequence)dependency.getElementFrom().getId(), (CharSequence)elementFrom.getId())) {
                context.addDependencyToDelete(dependency);
                return true;
            }
            return false;
        });
        elementFrom.getOutputDependencies().removeIf(dependency -> StringUtils.equals((CharSequence)dependency.getElementTo().getId(), (CharSequence)elementTo.getId()));
        Dependency referenceDependency = Dependency.of((ChainElement)elementFrom, (ChainElement)referenceElement);
        elementFrom.addOutputDependency(referenceDependency);
        referenceElement.addInputDependency(referenceDependency);
        context.getInProgressReferenceInputIds().remove(elementFrom.getId());
        return referenceElement;
    }

    protected void removeElementFromParentGroupIfRequired(ChainElement element, MigrationContext context) {
        if (element.getParent() != null && "container".equals(element.getParent().getType())) {
            ContainerChainElement parentGroup = element.getParent();
            this.removeElementFromParentGroupIfRequired((ChainElement)parentGroup, context);
            parentGroup.removeChildElement(element);
            if (parentGroup.getElements().isEmpty()) {
                context.addGroupToDelete((ChainElement)parentGroup);
                element.getChain().removeElement((ChainElement)parentGroup);
            }
        }
    }

    protected ContainerChainElement buildContainerFromChainElement(ChainElement chainElement) {
        return ((ContainerChainElement.ContainerChainElementBuilder)((ContainerChainElement.ContainerChainElementBuilder)((ContainerChainElement.ContainerChainElementBuilder)((ContainerChainElement.ContainerChainElementBuilder)((ContainerChainElement.ContainerChainElementBuilder)((ContainerChainElement.ContainerChainElementBuilder)((ContainerChainElement.ContainerChainElementBuilder)((ContainerChainElement.ContainerChainElementBuilder)((ContainerChainElement.ContainerChainElementBuilder)((ContainerChainElement.ContainerChainElementBuilder)((ContainerChainElement.ContainerChainElementBuilder)((ContainerChainElement.ContainerChainElementBuilder)((ContainerChainElement.ContainerChainElementBuilder)ContainerChainElement.builder().type(chainElement.getType())).name(chainElement.getName())).description(chainElement.getDescription())).createdBy(chainElement.getCreatedBy())).createdWhen(chainElement.getCreatedWhen())).modifiedBy(chainElement.getModifiedBy())).modifiedWhen(chainElement.getModifiedWhen())).originalId(chainElement.getOriginalId())).parent(chainElement.getParent())).chain(chainElement.getChain())).environment(chainElement.getEnvironment())).properties(chainElement.getProperties())).snapshot(chainElement.getSnapshot())).build();
    }
}

