/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.service.migration.element;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.qubership.integration.platform.catalog.persistence.configs.entity.AbstractEntity;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Dependency;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ContainerChainElement;
import org.qubership.integration.platform.catalog.service.library.LibraryElementsService;
import org.qubership.integration.platform.catalog.util.DistinctByKey;
import org.qubership.integration.platform.designtime.catalog.service.migration.element.ElementMigration;
import org.qubership.integration.platform.designtime.catalog.service.migration.element.MigrationContext;

public abstract class RestrictedContainerMigration
extends ElementMigration {
    protected RestrictedContainerMigration(LibraryElementsService libraryService, String oldElementType, String newElementType) {
        super(libraryService, oldElementType, newElementType);
    }

    public boolean canBeMigrated(ChainElement chainElement, MigrationContext context) {
        if (context.isElementChecked(chainElement)) {
            return true;
        }
        if (!(chainElement instanceof ContainerChainElement)) {
            return false;
        }
        context.getCheckedElementIds().add(chainElement.getId());
        return ((ContainerChainElement)chainElement).getElements().stream().filter(element -> !this.isElementDeprecated(element.getType())).allMatch(element -> Optional.ofNullable(context.getElementMigration(element.getType())).map(elementMigration -> elementMigration.canBeMigrated(element, context)).orElse(false));
    }

    public ChainElement migrate(ChainElement chainElement, MigrationContext context) {
        context.getInProgressElementIds().add(chainElement.getId());
        ContainerChainElement containerElement = (ContainerChainElement)chainElement;
        LinkedList<ChainElement> newChildren = new LinkedList<ChainElement>();
        LinkedList<ChainElement> deprecatedChildren = new LinkedList<ChainElement>();
        for (ChainElement child : containerElement.getElements()) {
            if (this.isElementDeprecated(child.getType())) {
                deprecatedChildren.add(child);
                continue;
            }
            ElementMigration elementMigration = context.getElementMigration(child.getType());
            if (elementMigration == null) continue;
            newChildren.add(elementMigration.migrate(child, context));
        }
        for (ChainElement deprecatedChild : deprecatedChildren) {
            this.migrateDeprecatedChild(containerElement, deprecatedChild, context);
            context.addElementToDelete(deprecatedChild);
        }
        containerElement.getElements().clear();
        containerElement.setType(this.getNewElementType());
        containerElement.addChildrenElements(newChildren);
        containerElement = this.postMigration(containerElement, context);
        context.getInProgressElementIds().remove(chainElement.getId());
        this.migrateNextElements((ChainElement)containerElement, context);
        return containerElement;
    }

    protected boolean isElementDeprecated(String elementType) {
        return false;
    }

    protected ContainerChainElement postMigration(ContainerChainElement containerElement, MigrationContext context) {
        return containerElement;
    }

    protected void migrateDeprecatedChild(ContainerChainElement parentElement, ChainElement deprecatedChild, MigrationContext context) {
        List<ChainElement> parentOutputElements = parentElement.getOutputDependencies().stream().peek(dependency -> dependency.getElementTo().getInputDependencies().remove(dependency)).peek(arg_0 -> ((MigrationContext)context).addDependencyToDelete(arg_0)).map(Dependency::getElementTo).toList();
        parentElement.getOutputDependencies().clear();
        for (Dependency outputDependency : deprecatedChild.getOutputDependencies()) {
            ChainElement elementTo = outputDependency.getElementTo();
            Dependency newDependency = Dependency.of((ChainElement)parentElement, (ChainElement)elementTo);
            parentElement.addOutputDependency(newDependency);
            elementTo.getInputDependencies().remove(outputDependency);
            elementTo.addInputDependency(newDependency);
        }
        this.extractBranchEndElements(deprecatedChild).stream().filter(DistinctByKey.newInstance(AbstractEntity::getId)).forEach(endElement -> {
            for (ChainElement parentOutputElement : parentOutputElements) {
                Dependency newDependency = Dependency.of((ChainElement)endElement, (ChainElement)parentOutputElement);
                endElement.addOutputDependency(newDependency);
                parentOutputElement.addInputDependency(newDependency);
            }
        });
    }

    private List<ChainElement> extractBranchEndElements(ChainElement chainElement) {
        ArrayList<ChainElement> branchEndElements = new ArrayList<ChainElement>();
        for (Dependency outputDependency : chainElement.getOutputDependencies()) {
            ChainElement elementTo = outputDependency.getElementTo();
            if (elementTo.getOutputDependencies().isEmpty()) {
                branchEndElements.add(elementTo);
                continue;
            }
            branchEndElements.addAll(this.extractBranchEndElements(elementTo));
        }
        return branchEndElements;
    }
}

