/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.service.migration.element;

import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.catalog.model.library.ElementDescriptor;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Dependency;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ContainerChainElement;
import org.qubership.integration.platform.catalog.service.library.LibraryElementsService;
import org.qubership.integration.platform.designtime.catalog.service.migration.element.ElementMigration;
import org.qubership.integration.platform.designtime.catalog.service.migration.element.MigrationContext;

public abstract class SimpleContainerMigration
extends ElementMigration {
    protected SimpleContainerMigration(LibraryElementsService libraryService, String oldElementType, String newElementType) {
        super(libraryService, oldElementType, newElementType);
    }

    public boolean canBeMigrated(ChainElement chainElement, MigrationContext context) {
        ElementDescriptor descriptor = this.libraryService.getElementDescriptor(this.getNewElementType());
        if (descriptor == null) {
            return false;
        }
        return this.isOutputDependenciesValid(chainElement, context);
    }

    public ChainElement migrate(ChainElement chainElement, MigrationContext context) {
        List children = this.collectChildren(chainElement, context);
        ContainerChainElement newChainElement = this.buildContainerFromChainElement(chainElement);
        newChainElement.setType(this.getNewElementType());
        newChainElement.addChildrenElements((Collection)children);
        context.addElementToDelete(chainElement);
        context.addMigratedElement((ChainElement)newChainElement);
        for (Dependency outputDependency : chainElement.getOutputDependencies()) {
            outputDependency.getElementTo().getInputDependencies().removeIf(dependency -> StringUtils.equals((CharSequence)dependency.getElementFrom().getId(), (CharSequence)chainElement.getId()));
        }
        return newChainElement;
    }

    private boolean isOutputDependenciesValid(ChainElement chainElement, MigrationContext context) {
        for (Dependency outputDependency : chainElement.getOutputDependencies()) {
            ChainElement elementTo = outputDependency.getElementTo();
            ElementMigration elementMigration = context.getElementMigration(elementTo.getType());
            if (elementMigration != null && !elementMigration.canBeMigrated(elementTo, context)) {
                return false;
            }
            if (this.isOutputDependenciesValid(elementTo, context)) continue;
            return false;
        }
        return true;
    }
}

