/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.qubership.integration.platform.catalog.persistence.configs.entity.AbstractEntity;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Dependency;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ContainerChainElement;
import org.qubership.integration.platform.catalog.service.library.LibraryElementsService;
import org.qubership.integration.platform.catalog.util.DistinctByKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;

@Component
public class OldContainerUtils {
    private final LibraryElementsService libraryService;

    @Autowired
    public OldContainerUtils(LibraryElementsService libraryService) {
        this.libraryService = libraryService;
    }

    @Nullable
    public ContainerChainElement getOldContainerParent(ContainerChainElement element) {
        ContainerChainElement parentElement;
        if (element == null || !this.isOldStyleContainer(element.getType())) {
            return element;
        }
        for (parentElement = element.getParent(); parentElement != null && "container".equals(parentElement.getType()); parentElement = parentElement.getParent()) {
        }
        return parentElement;
    }

    public List<Dependency> extractOldContainerOutputDependencies(ChainElement element) {
        if (this.isOldStyleContainer(element.getType())) {
            return ((ContainerChainElement)element).getElements().stream().map(ChainElement::getOutputDependencies).flatMap(Collection::stream).collect(Collectors.toList());
        }
        return new ArrayList<Dependency>();
    }

    public boolean isOldStyleContainer(String elementType) {
        return Optional.ofNullable(this.libraryService.getElementDescriptor(elementType)).map(descriptor -> descriptor.isContainer() && descriptor.isOldStyleContainer()).orElse(false);
    }

    public List<ChainElement> getAllOldStyleContainerChildren(@NonNull ChainElement element) {
        if (!this.isOldStyleContainer(element.getType())) {
            return Collections.emptyList();
        }
        return ((ContainerChainElement)element).getElements().stream().map(arg_0 -> this.collectAllOldStyleContainerDependentElements(arg_0)).flatMap(Collection::stream).filter(DistinctByKey.newInstance(AbstractEntity::getId)).toList();
    }

    private List<ChainElement> collectAllOldStyleContainerDependentElements(ChainElement element) {
        ArrayList<ChainElement> result = new ArrayList<ChainElement>();
        List<ChainElement> elementsTo = element.getOutputDependencies().stream().map(Dependency::getElementTo).toList();
        for (ChainElement elementTo : elementsTo) {
            if (this.isOldStyleContainer(elementTo.getType())) {
                ((ContainerChainElement)elementTo).getElements().stream().map(arg_0 -> this.collectAllOldStyleContainerDependentElements(arg_0)).flatMap(Collection::stream).forEach(result::add);
            }
            result.addAll(this.collectAllOldStyleContainerDependentElements(elementTo));
            result.add(elementTo);
        }
        return result;
    }
}

