/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.utils.escaping;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.designtime.catalog.utils.escaping.EscapeUtilExclude;
import org.qubership.integration.platform.designtime.catalog.utils.escaping.EscapeUtilsException;

/*
 * Exception performing whole class analysis ignored.
 */
public class EscapeUtils {
    private static final Set<Character> ESCAPED_CHARS = "\\*_{}[]()<>#+!|".chars().mapToObj(a -> Character.valueOf((char)a)).collect(Collectors.toSet());
    public static final int UNPRINTABLE_SYMBOLS_THRESHOLD = 32;
    public static final String LINE_BREAK = "<br>";

    public static <T> void escapeMarkdownDataRecursive(T object) throws IllegalAccessException, EscapeUtilsException {
        Set viewedObjects = Collections.newSetFromMap(new IdentityHashMap());
        EscapeUtils.escapeMarkdownDataRecursive(object, viewedObjects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> void escapeMarkdownDataRecursive(T object, Set<Object> viewedObjects) throws IllegalAccessException, EscapeUtilsException {
        Field[] fields;
        if (viewedObjects.contains(object)) {
            throw new EscapeUtilsException("Object reference loop detected");
        }
        viewedObjects.add(object);
        if (object == null || object.getClass().isPrimitive() || object instanceof Enum) {
            viewedObjects.remove(object);
            return;
        }
        if (object instanceof Map) {
            Map mapObject = (Map)object;
            for (Map.Entry entry : mapObject.entrySet()) {
                Map.Entry entry2 = entry;
                Object value = entry2.getValue();
                if (value instanceof String) {
                    String stringObject = (String)value;
                    String escapeResult = EscapeUtils.escapeAndReplaceForMarkdown((String)stringObject);
                    entry2.setValue(escapeResult);
                    continue;
                }
                EscapeUtils.escapeMarkdownDataRecursive(value);
            }
            viewedObjects.remove(object);
            return;
        }
        if (object instanceof List) {
            List listObject = (List)object;
            for (int i = 0; i < listObject.size(); ++i) {
                Object e = listObject.get(i);
                if (e instanceof String) {
                    String stringObject = (String)e;
                    String escapeResult = EscapeUtils.escapeAndReplaceForMarkdown((String)stringObject);
                    listObject.set(i, escapeResult);
                    continue;
                }
                EscapeUtils.escapeMarkdownDataRecursive(e);
            }
            viewedObjects.remove(object);
            return;
        }
        for (Field field : fields = object.getClass().getDeclaredFields()) {
            Class<?> fieldType = field.getType();
            int modifiers = field.getModifiers();
            if (Modifier.isFinal(modifiers) || Modifier.isStatic(modifiers) || field.isAnnotationPresent(EscapeUtilExclude.class)) continue;
            boolean accessible = field.canAccess(object);
            if (!accessible) {
                field.setAccessible(true);
            }
            try {
                Object fieldValue = field.get(object);
                if (fieldType == String.class) {
                    String escapeResult = EscapeUtils.escapeAndReplaceForMarkdown((String)((String)fieldValue));
                    field.set(object, escapeResult);
                    continue;
                }
                EscapeUtils.escapeMarkdownDataRecursive((Object)fieldValue);
            }
            finally {
                if (!accessible) {
                    field.setAccessible(false);
                }
            }
        }
        viewedObjects.remove(object);
    }

    private static String escapeAndReplaceForMarkdown(String input) {
        if (StringUtils.isEmpty((CharSequence)input)) {
            return input;
        }
        StringBuilder sb = new StringBuilder(input.length() + (int)((double)input.length() * 0.08));
        for (int i = 0; i < input.length(); ++i) {
            int c = input.charAt(i);
            if (ESCAPED_CHARS.contains(Character.valueOf((char)c))) {
                sb.append("\\");
            }
            if (c == 10 || c == 13) {
                sb.append("<br>");
                continue;
            }
            c = c >= 32 ? c : 32;
            sb.append((char)c);
        }
        return sb.toString();
    }
}

