/*
 * Copyright 2024-2025 NetCracker Technology Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.qubership.integration.platform.designtime.catalog.exception.exceptions;

public class FolderMoveException extends Exception {
    public FolderMoveException(String message) {
        super(message);
    }

    public FolderMoveException(String parentFolderName, String childFolderName) {
        super("Movement of parent folder '" + parentFolderName + "' to child folder '" + childFolderName + "' is not allowed");
    }
}
