package org.qubership.integration.platform.designtime.catalog.rest.v1.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.Generated;
import org.qubership.integration.platform.catalog.mapping.UserMapper;
import org.qubership.integration.platform.catalog.model.dto.BaseResponse;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.ChainLabel;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Folder;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Snapshot;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.SwimlaneChainElement;
import org.qubership.integration.platform.catalog.util.MapperUtils;
import org.qubership.integration.platform.catalog.util.StringTrimmer;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.chain.ChainDTO;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.chain.ChainLabelDTO;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.chain.ChainRequest;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.chain.ChainResponse;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.chain.ChainsBySpecificationGroup;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.folder.FolderItemResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2025-10-07T14:55:51+0000",
    comments = "version: 1.5.5.Final, compiler: javac, environment: Java 21.0.8 (Eclipse Adoptium)"
)
@Component
public class ChainMapperImpl implements ChainMapper {

    @Autowired
    private DependencyMapper dependencyMapper;
    @Autowired
    private ElementMapper elementMapper;
    @Autowired
    private DeploymentMapper deploymentMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private StringTrimmer stringTrimmer;
    @Autowired
    private ChainLabelsMapper chainLabelsMapper;

    @Override
    public ChainDTO asDTO(Chain chain) {
        if ( chain == null ) {
            return null;
        }

        ChainDTO.ChainDTOBuilder<?, ?> chainDTO = ChainDTO.builder();

        chainDTO.currentSnapshot( snapshotToBaseResponse( chain.getCurrentSnapshot() ) );
        chainDTO.dependencies( dependencyMapper.extractDependencies( chain.getElements() ) );
        chainDTO.elements( elementMapper.toElementResponses( chain ) );
        chainDTO.parentId( stringTrimmer.trimString( chainParentFolderId( chain ) ) );
        chainDTO.defaultSwimlaneId( stringTrimmer.trimString( chainDefaultSwimlaneId( chain ) ) );
        chainDTO.reuseSwimlaneId( stringTrimmer.trimString( chainReuseSwimlaneId( chain ) ) );
        chainDTO.overriddenByChainName( stringTrimmer.trimString( chainOverriddenByChainName( chain ) ) );
        chainDTO.overridesChainName( stringTrimmer.trimString( chainOverridesChainName( chain ) ) );
        chainDTO.id( stringTrimmer.trimString( chain.getId() ) );
        chainDTO.name( stringTrimmer.trimString( chain.getName() ) );
        chainDTO.description( stringTrimmer.trimString( chain.getDescription() ) );
        chainDTO.createdWhen( MapperUtils.fromTimestamp( chain.getCreatedWhen() ) );
        chainDTO.createdBy( userMapper.asDTO( chain.getCreatedBy() ) );
        chainDTO.modifiedWhen( MapperUtils.fromTimestamp( chain.getModifiedWhen() ) );
        chainDTO.modifiedBy( userMapper.asDTO( chain.getModifiedBy() ) );
        chainDTO.deployments( deploymentMapper.asResponses( chain.getDeployments() ) );
        chainDTO.labels( chainLabelSetToChainLabelDTOList( chain.getLabels() ) );
        chainDTO.unsavedChanges( chain.isUnsavedChanges() );
        chainDTO.businessDescription( stringTrimmer.trimString( chain.getBusinessDescription() ) );
        chainDTO.assumptions( stringTrimmer.trimString( chain.getAssumptions() ) );
        chainDTO.outOfScope( stringTrimmer.trimString( chain.getOutOfScope() ) );
        chainDTO.overriddenByChainId( stringTrimmer.trimString( chain.getOverriddenByChainId() ) );
        chainDTO.overridesChainId( stringTrimmer.trimString( chain.getOverridesChainId() ) );

        return chainDTO.build();
    }

    @Override
    public List<ChainDTO> asDTO(List<Chain> chains) {
        if ( chains == null ) {
            return null;
        }

        List<ChainDTO> list = new ArrayList<ChainDTO>( chains.size() );
        for ( Chain chain : chains ) {
            list.add( asDTO( chain ) );
        }

        return list;
    }

    @Override
    public List<FolderItemResponse> asFolderItemResponse(Collection<Chain> chains) {
        if ( chains == null ) {
            return null;
        }

        List<FolderItemResponse> list = new ArrayList<FolderItemResponse>( chains.size() );
        for ( Chain chain : chains ) {
            list.add( asFolderItemResponse( chain ) );
        }

        return list;
    }

    @Override
    public FolderItemResponse asFolderItemResponse(Chain chain) {
        if ( chain == null ) {
            return null;
        }

        FolderItemResponse.FolderItemResponseBuilder<?, ?> folderItemResponse = FolderItemResponse.builder();

        folderItemResponse.parentId( stringTrimmer.trimString( chainParentFolderId( chain ) ) );
        folderItemResponse.overriddenByChainName( stringTrimmer.trimString( chainOverriddenByChainName( chain ) ) );
        folderItemResponse.overridesChainName( stringTrimmer.trimString( chainOverridesChainName( chain ) ) );
        folderItemResponse.id( stringTrimmer.trimString( chain.getId() ) );
        folderItemResponse.name( stringTrimmer.trimString( chain.getName() ) );
        folderItemResponse.description( stringTrimmer.trimString( chain.getDescription() ) );
        folderItemResponse.createdWhen( MapperUtils.fromTimestamp( chain.getCreatedWhen() ) );
        folderItemResponse.createdBy( userMapper.asDTO( chain.getCreatedBy() ) );
        folderItemResponse.modifiedWhen( MapperUtils.fromTimestamp( chain.getModifiedWhen() ) );
        folderItemResponse.modifiedBy( userMapper.asDTO( chain.getModifiedBy() ) );
        folderItemResponse.labels( chainLabelSetToChainLabelDTOList( chain.getLabels() ) );
        folderItemResponse.deployments( deploymentMapper.asResponses( chain.getDeployments() ) );
        folderItemResponse.businessDescription( stringTrimmer.trimString( chain.getBusinessDescription() ) );
        folderItemResponse.assumptions( stringTrimmer.trimString( chain.getAssumptions() ) );
        folderItemResponse.outOfScope( stringTrimmer.trimString( chain.getOutOfScope() ) );
        folderItemResponse.overriddenByChainId( stringTrimmer.trimString( chain.getOverriddenByChainId() ) );
        folderItemResponse.overridesChainId( stringTrimmer.trimString( chain.getOverridesChainId() ) );

        return folderItemResponse.build();
    }

    @Override
    public ChainResponse asChainResponseLight(Chain chain) {
        if ( chain == null ) {
            return null;
        }

        ChainResponse.ChainResponseBuilder<?, ?> chainResponse = ChainResponse.builder();

        chainResponse.parentId( stringTrimmer.trimString( chainParentFolderId( chain ) ) );
        chainResponse.defaultSwimlaneId( stringTrimmer.trimString( chainDefaultSwimlaneId( chain ) ) );
        chainResponse.reuseSwimlaneId( stringTrimmer.trimString( chainReuseSwimlaneId( chain ) ) );
        chainResponse.id( stringTrimmer.trimString( chain.getId() ) );
        chainResponse.name( stringTrimmer.trimString( chain.getName() ) );
        chainResponse.description( stringTrimmer.trimString( chain.getDescription() ) );
        chainResponse.createdWhen( MapperUtils.fromTimestamp( chain.getCreatedWhen() ) );
        chainResponse.createdBy( userMapper.asDTO( chain.getCreatedBy() ) );
        chainResponse.modifiedWhen( MapperUtils.fromTimestamp( chain.getModifiedWhen() ) );
        chainResponse.modifiedBy( userMapper.asDTO( chain.getModifiedBy() ) );
        chainResponse.labels( chainLabelSetToChainLabelDTOList( chain.getLabels() ) );

        return chainResponse.build();
    }

    @Override
    public List<ChainResponse> asChainResponseLight(List<Chain> response) {
        if ( response == null ) {
            return null;
        }

        List<ChainResponse> list = new ArrayList<ChainResponse>( response.size() );
        for ( Chain chain : response ) {
            list.add( asChainResponseLight( chain ) );
        }

        return list;
    }

    @Override
    public ChainsBySpecificationGroup asChainsBySpecificationGroup(String specificationGroupId, List<Chain> chains) {
        if ( specificationGroupId == null && chains == null ) {
            return null;
        }

        ChainsBySpecificationGroup.ChainsBySpecificationGroupBuilder<?, ?> chainsBySpecificationGroup = ChainsBySpecificationGroup.builder();

        chainsBySpecificationGroup.specificationGroupId( stringTrimmer.trimString( specificationGroupId ) );
        chainsBySpecificationGroup.chains( asChainResponseLight( chains ) );

        return chainsBySpecificationGroup.build();
    }

    @Override
    public Chain mapRequest(ChainRequest request) {
        if ( request == null ) {
            return null;
        }

        Chain.ChainBuilder<?, ?> chain = Chain.builder();

        chain.name( stringTrimmer.trimString( request.getName() ) );
        chain.description( stringTrimmer.trimString( request.getDescription() ) );
        chain.labels( chainLabelDTOListToChainLabelSet( request.getLabels() ) );
        chain.businessDescription( stringTrimmer.trimString( request.getBusinessDescription() ) );
        chain.assumptions( stringTrimmer.trimString( request.getAssumptions() ) );
        chain.outOfScope( stringTrimmer.trimString( request.getOutOfScope() ) );

        return chain.build();
    }

    @Override
    public void mergeWithoutLabels(Chain chain, ChainRequest chainRequest) {
        if ( chainRequest == null ) {
            return;
        }

        if ( chainRequest.getName() != null ) {
            chain.setName( stringTrimmer.trimString( chainRequest.getName() ) );
        }
        if ( chainRequest.getDescription() != null ) {
            chain.setDescription( stringTrimmer.trimString( chainRequest.getDescription() ) );
        }
        if ( chainRequest.getBusinessDescription() != null ) {
            chain.setBusinessDescription( stringTrimmer.trimString( chainRequest.getBusinessDescription() ) );
        }
        if ( chainRequest.getAssumptions() != null ) {
            chain.setAssumptions( stringTrimmer.trimString( chainRequest.getAssumptions() ) );
        }
        if ( chainRequest.getOutOfScope() != null ) {
            chain.setOutOfScope( stringTrimmer.trimString( chainRequest.getOutOfScope() ) );
        }
    }

    protected BaseResponse snapshotToBaseResponse(Snapshot snapshot) {
        if ( snapshot == null ) {
            return null;
        }

        BaseResponse.BaseResponseBuilder<?, ?> baseResponse = BaseResponse.builder();

        baseResponse.id( stringTrimmer.trimString( snapshot.getId() ) );
        baseResponse.name( stringTrimmer.trimString( snapshot.getName() ) );
        baseResponse.description( stringTrimmer.trimString( snapshot.getDescription() ) );
        baseResponse.createdWhen( MapperUtils.fromTimestamp( snapshot.getCreatedWhen() ) );
        baseResponse.createdBy( userMapper.asDTO( snapshot.getCreatedBy() ) );
        baseResponse.modifiedWhen( MapperUtils.fromTimestamp( snapshot.getModifiedWhen() ) );
        baseResponse.modifiedBy( userMapper.asDTO( snapshot.getModifiedBy() ) );

        return baseResponse.build();
    }

    private String chainParentFolderId(Chain chain) {
        if ( chain == null ) {
            return null;
        }
        Folder parentFolder = chain.getParentFolder();
        if ( parentFolder == null ) {
            return null;
        }
        String id = parentFolder.getId();
        if ( id == null ) {
            return null;
        }
        return id;
    }

    private String chainDefaultSwimlaneId(Chain chain) {
        if ( chain == null ) {
            return null;
        }
        SwimlaneChainElement defaultSwimlane = chain.getDefaultSwimlane();
        if ( defaultSwimlane == null ) {
            return null;
        }
        String id = defaultSwimlane.getId();
        if ( id == null ) {
            return null;
        }
        return id;
    }

    private String chainReuseSwimlaneId(Chain chain) {
        if ( chain == null ) {
            return null;
        }
        SwimlaneChainElement reuseSwimlane = chain.getReuseSwimlane();
        if ( reuseSwimlane == null ) {
            return null;
        }
        String id = reuseSwimlane.getId();
        if ( id == null ) {
            return null;
        }
        return id;
    }

    private String chainOverriddenByChainName(Chain chain) {
        if ( chain == null ) {
            return null;
        }
        Chain overriddenByChain = chain.getOverriddenByChain();
        if ( overriddenByChain == null ) {
            return null;
        }
        String name = overriddenByChain.getName();
        if ( name == null ) {
            return null;
        }
        return name;
    }

    private String chainOverridesChainName(Chain chain) {
        if ( chain == null ) {
            return null;
        }
        Chain overridesChain = chain.getOverridesChain();
        if ( overridesChain == null ) {
            return null;
        }
        String name = overridesChain.getName();
        if ( name == null ) {
            return null;
        }
        return name;
    }

    protected List<ChainLabelDTO> chainLabelSetToChainLabelDTOList(Set<ChainLabel> set) {
        if ( set == null ) {
            return null;
        }

        List<ChainLabelDTO> list = new ArrayList<ChainLabelDTO>( set.size() );
        for ( ChainLabel chainLabel : set ) {
            list.add( chainLabelsMapper.asDTO( chainLabel ) );
        }

        return list;
    }

    protected ChainLabel chainLabelDTOToChainLabel(ChainLabelDTO chainLabelDTO) {
        if ( chainLabelDTO == null ) {
            return null;
        }

        ChainLabel.ChainLabelBuilder<?, ?> chainLabel = ChainLabel.builder();

        chainLabel.name( stringTrimmer.trimString( chainLabelDTO.getName() ) );
        if ( chainLabelDTO.getTechnical() != null ) {
            chainLabel.technical( chainLabelDTO.getTechnical() );
        }

        return chainLabel.build();
    }

    protected Set<ChainLabel> chainLabelDTOListToChainLabelSet(List<ChainLabelDTO> list) {
        if ( list == null ) {
            return null;
        }

        Set<ChainLabel> set = new LinkedHashSet<ChainLabel>( Math.max( (int) ( list.size() / .75f ) + 1, 16 ) );
        for ( ChainLabelDTO chainLabelDTO : list ) {
            set.add( chainLabelDTOToChainLabel( chainLabelDTO ) );
        }

        return set;
    }
}
