package org.qubership.integration.platform.designtime.catalog.rest.v1.mapping;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.Generated;
import org.qubership.integration.platform.catalog.mapping.UserMapper;
import org.qubership.integration.platform.catalog.model.deployment.engine.EngineDeployment;
import org.qubership.integration.platform.catalog.model.dto.deployment.DeploymentResponse;
import org.qubership.integration.platform.catalog.model.dto.deployment.RuntimeDeploymentState;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Deployment;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Snapshot;
import org.qubership.integration.platform.catalog.util.MapperUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2025-10-07T14:55:50+0000",
    comments = "version: 1.5.5.Final, compiler: javac, environment: Java 21.0.8 (Eclipse Adoptium)"
)
@Component
public class DeploymentMapperImpl extends DeploymentMapper {

    @Autowired
    private UserMapper userMapper;

    @Override
    public DeploymentResponse asResponse(Deployment deployment) {
        if ( deployment == null ) {
            return null;
        }

        DeploymentResponse.DeploymentResponseBuilder deploymentResponse = DeploymentResponse.builder();

        deploymentResponse.snapshotId( deploymentSnapshotId( deployment ) );
        deploymentResponse.chainId( deploymentChainId( deployment ) );
        deploymentResponse.id( deployment.getId() );
        deploymentResponse.name( deployment.getName() );
        deploymentResponse.domain( deployment.getDomain() );
        deploymentResponse.createdWhen( MapperUtils.fromTimestamp( deployment.getCreatedWhen() ) );
        deploymentResponse.createdBy( userMapper.asDTO( deployment.getCreatedBy() ) );
        deploymentResponse.suspended( deployment.isSuspended() );

        return deploymentResponse.build();
    }

    @Override
    public List<DeploymentResponse> asResponses(List<Deployment> deploymentEntityEngineList) {
        if ( deploymentEntityEngineList == null ) {
            return null;
        }

        List<DeploymentResponse> list = new ArrayList<DeploymentResponse>( deploymentEntityEngineList.size() );
        for ( Deployment deployment : deploymentEntityEngineList ) {
            list.add( asResponse( deployment ) );
        }

        return list;
    }

    @Override
    public RuntimeDeploymentState toDTO(EngineDeployment state) {
        if ( state == null ) {
            return null;
        }

        RuntimeDeploymentState runtimeDeploymentState = new RuntimeDeploymentState();

        runtimeDeploymentState.setStatus( state.getStatus() );
        runtimeDeploymentState.setError( state.getErrorMessage() );
        runtimeDeploymentState.setSuspended( state.isSuspended() );

        return runtimeDeploymentState;
    }

    private String deploymentSnapshotId(Deployment deployment) {
        if ( deployment == null ) {
            return null;
        }
        Snapshot snapshot = deployment.getSnapshot();
        if ( snapshot == null ) {
            return null;
        }
        String id = snapshot.getId();
        if ( id == null ) {
            return null;
        }
        return id;
    }

    private String deploymentChainId(Deployment deployment) {
        if ( deployment == null ) {
            return null;
        }
        Chain chain = deployment.getChain();
        if ( chain == null ) {
            return null;
        }
        String id = chain.getId();
        if ( id == null ) {
            return null;
        }
        return id;
    }
}
