package org.qubership.integration.platform.designtime.catalog.rest.v1.mapping;

import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.processing.Generated;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.MaskedField;
import org.qubership.integration.platform.catalog.util.MapperUtils;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.masking.MaskedFieldDTO;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.masking.MaskedFieldsResponse;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2025-10-07T14:55:50+0000",
    comments = "version: 1.5.5.Final, compiler: javac, environment: Java 21.0.8 (Eclipse Adoptium)"
)
@Component
public class MaskedFieldsMapperImpl implements MaskedFieldsMapper {

    @Override
    public MaskedFieldsResponse asResponse(Chain entity) {
        if ( entity == null ) {
            return null;
        }

        MaskedFieldsResponse.MaskedFieldsResponseBuilder maskedFieldsResponse = MaskedFieldsResponse.builder();

        maskedFieldsResponse.fields( maskedFieldSetToMaskedFieldDTOSet( entity.getMaskedFields() ) );

        return maskedFieldsResponse.build();
    }

    @Override
    public MaskedFieldDTO asDto(MaskedField entity) {
        if ( entity == null ) {
            return null;
        }

        MaskedFieldDTO.MaskedFieldDTOBuilder maskedFieldDTO = MaskedFieldDTO.builder();

        maskedFieldDTO.id( entity.getId() );
        maskedFieldDTO.name( entity.getName() );
        maskedFieldDTO.createdWhen( MapperUtils.fromTimestamp( entity.getCreatedWhen() ) );
        maskedFieldDTO.createdBy( entity.getCreatedBy() );
        maskedFieldDTO.modifiedWhen( MapperUtils.fromTimestamp( entity.getModifiedWhen() ) );
        maskedFieldDTO.modifiedBy( entity.getModifiedBy() );

        return maskedFieldDTO.build();
    }

    @Override
    public MaskedField asEntity(Chain chain, MaskedFieldDTO dto) {
        if ( chain == null && dto == null ) {
            return null;
        }

        MaskedField.MaskedFieldBuilder<?, ?> maskedField = MaskedField.builder();

        if ( dto != null ) {
            maskedField.name( dto.getName() );
            maskedField.createdBy( dto.getCreatedBy() );
            maskedField.createdWhen( MapperUtils.toTimestamp( dto.getCreatedWhen() ) );
            maskedField.modifiedBy( dto.getModifiedBy() );
            maskedField.modifiedWhen( MapperUtils.toTimestamp( dto.getModifiedWhen() ) );
        }
        maskedField.chain( chain );

        return maskedField.build();
    }

    @Override
    public MaskedField asEntity(MaskedFieldDTO dto) {
        if ( dto == null ) {
            return null;
        }

        MaskedField.MaskedFieldBuilder<?, ?> maskedField = MaskedField.builder();

        maskedField.id( dto.getId() );
        maskedField.name( dto.getName() );
        maskedField.createdWhen( MapperUtils.toTimestamp( dto.getCreatedWhen() ) );
        maskedField.modifiedWhen( MapperUtils.toTimestamp( dto.getModifiedWhen() ) );
        maskedField.createdBy( dto.getCreatedBy() );
        maskedField.modifiedBy( dto.getModifiedBy() );

        return maskedField.build();
    }

    protected Set<MaskedFieldDTO> maskedFieldSetToMaskedFieldDTOSet(Set<MaskedField> set) {
        if ( set == null ) {
            return null;
        }

        Set<MaskedFieldDTO> set1 = new LinkedHashSet<MaskedFieldDTO>( Math.max( (int) ( set.size() / .75f ) + 1, 16 ) );
        for ( MaskedField maskedField : set ) {
            set1.add( asDto( maskedField ) );
        }

        return set1;
    }
}
