package org.qubership.integration.platform.designtime.catalog.rest.v1.mapping;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Generated;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.Operation;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.SystemModel;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.OperationDTO;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.OperationInfoDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2025-10-07T14:55:50+0000",
    comments = "version: 1.5.5.Final, compiler: javac, environment: Java 21.0.8 (Eclipse Adoptium)"
)
@Component
public class OperationMapperImpl implements OperationMapper {

    @Autowired
    private ChainBaseMapper chainBaseMapper;

    @Override
    public OperationDTO toOperationDTO(Operation operation) {
        if ( operation == null ) {
            return null;
        }

        OperationDTO operationDTO = new OperationDTO();

        operationDTO.setId( operation.getId() );
        operationDTO.setName( operation.getName() );
        operationDTO.setMethod( operation.getMethod() );
        operationDTO.setPath( operation.getPath() );
        operationDTO.setModelId( operationSystemModelId( operation ) );
        operationDTO.setSpecification( operation.getSpecification() );
        operationDTO.setDescription( operation.getDescription() );
        operationDTO.setChains( chainBaseMapper.asDTO( operation.getChains() ) );

        return operationDTO;
    }

    @Override
    public List<OperationDTO> toOperationDTOs(List<Operation> operations) {
        if ( operations == null ) {
            return null;
        }

        List<OperationDTO> list = new ArrayList<OperationDTO>( operations.size() );
        for ( Operation operation : operations ) {
            list.add( toOperationDTO( operation ) );
        }

        return list;
    }

    @Override
    public OperationInfoDTO toOperationInfoDTO(Operation operation) {
        if ( operation == null ) {
            return null;
        }

        OperationInfoDTO.OperationInfoDTOBuilder operationInfoDTO = OperationInfoDTO.builder();

        operationInfoDTO.id( operation.getId() );
        operationInfoDTO.specification( operation.getSpecification() );
        Map<String, JsonNode> map = operation.getRequestSchema();
        if ( map != null ) {
            operationInfoDTO.requestSchema( new LinkedHashMap<String, JsonNode>( map ) );
        }
        Map<String, JsonNode> map1 = operation.getResponseSchemas();
        if ( map1 != null ) {
            operationInfoDTO.responseSchemas( new LinkedHashMap<String, JsonNode>( map1 ) );
        }

        return operationInfoDTO.build();
    }

    private String operationSystemModelId(Operation operation) {
        if ( operation == null ) {
            return null;
        }
        SystemModel systemModel = operation.getSystemModel();
        if ( systemModel == null ) {
            return null;
        }
        String id = systemModel.getId();
        if ( id == null ) {
            return null;
        }
        return id;
    }
}
