/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.configuration;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.designtime.catalog.service.codeview.deserializer.CodeviewChainElementDeserializer;
import org.qubership.integration.platform.designtime.catalog.service.codeview.serializer.CodeviewChainElementSerializer;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.yaml.snakeyaml.LoaderOptions;

@AutoConfiguration
public class MapperAutoConfiguration {
    private static final int CODE_POINT_LIMIT_MB = 256;

    @Bean(value={"yamlMapper"})
    public YAMLMapper yamlMapper() {
        YAMLMapper yamlMapper = new YAMLMapper(this.createCustomYamlFactory());
        SimpleModule serializeModule = new SimpleModule();
        yamlMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        yamlMapper.registerModule((Module)serializeModule);
        yamlMapper.setFilterProvider((FilterProvider)new SimpleFilterProvider().setFailOnUnknownId(false));
        return yamlMapper;
    }

    @Bean(value={"codeViewYamlMapper"})
    public YAMLMapper codeViewYamlMapper(ObjectMapper objectMapper) {
        YAMLMapper yamlMapper = new YAMLMapper(this.createCustomYamlFactory());
        SimpleModule serializeModule = new SimpleModule();
        yamlMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        serializeModule.addSerializer(ChainElement.class, (JsonSerializer)new CodeviewChainElementSerializer());
        serializeModule.addDeserializer(ChainElement.class, (JsonDeserializer)new CodeviewChainElementDeserializer(objectMapper));
        yamlMapper.registerModule((Module)serializeModule);
        return yamlMapper;
    }

    private YAMLFactory createCustomYamlFactory() {
        LoaderOptions loaderOptions = new LoaderOptions();
        loaderOptions.setCodePointLimit(0x10000000);
        return YAMLFactory.builder().loaderOptions(loaderOptions).build();
    }
}

