/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.configuration.aspect;

import java.util.List;
import java.util.Optional;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Dependency;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.MaskedField;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ContainerChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.repository.chain.ChainRepository;
import org.qubership.integration.platform.designtime.catalog.model.ChainDiff;
import org.qubership.integration.platform.designtime.catalog.service.migration.MigratedChain;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

@Aspect
@Configuration
public class UnsavedChangesAspectConfiguration {
    private final ChainRepository chainRepository;

    @Autowired
    public UnsavedChangesAspectConfiguration(ChainRepository chainRepository) {
        this.chainRepository = chainRepository;
    }

    @Pointcut(value="@annotation(org.qubership.integration.platform.designtime.catalog.configuration.aspect.ChainModification)")
    public void detectChainUnsavedChanges() {
    }

    @AfterReturning(value="detectChainUnsavedChanges()", returning="returningValue")
    public void markChainAsUnsaved(Object returningValue) {
        Chain chain;
        String chainId = null;
        boolean markUnsavedChanges = true;
        if (returningValue != null) {
            MigratedChain migratedChain;
            ContainerChainElement containerChainElement;
            List returningList;
            if (returningValue instanceof List && !(returningList = (List)returningValue).isEmpty()) {
                Object e = returningList.get(0);
                if (e instanceof ChainElement) {
                    ChainElement firstElement = (ChainElement)e;
                    chainId = this.getChainIdFromElement(firstElement);
                }
                if ((e = returningList.get(0)) instanceof Dependency) {
                    Dependency firstDependency = (Dependency)e;
                    chainId = this.getChainIdFromElement(firstDependency.getElementFrom() != null ? firstDependency.getElementFrom() : firstDependency.getElementTo());
                }
            }
            if (returningValue instanceof Chain) {
                markUnsavedChanges = false;
                chainId = ((Chain)returningValue).getId();
            }
            if (returningValue instanceof Dependency) {
                Dependency dependency = (Dependency)returningValue;
                chainId = this.getChainIdFromElement(dependency.getElementFrom() != null ? dependency.getElementFrom() : dependency.getElementTo());
            }
            if (returningValue instanceof ChainElement) {
                chainId = this.getChainIdFromElement((ChainElement)returningValue);
            }
            if (returningValue instanceof ContainerChainElement && (containerChainElement = (ContainerChainElement)returningValue).getChain() != null) {
                chainId = containerChainElement.getChain().getId();
            }
            if (returningValue instanceof ChainDiff) {
                chainId = this.extractChainIdFromChainDiff((ChainDiff)returningValue);
            }
            if (returningValue instanceof MaskedField && ((MaskedField)returningValue).getChain() != null) {
                chainId = ((MaskedField)returningValue).getChain().getId();
            }
            if (returningValue instanceof MigratedChain && (migratedChain = (MigratedChain)returningValue).getChain() != null) {
                chainId = migratedChain.getChain().getId();
            }
        }
        if (chainId != null && markUnsavedChanges && !(chain = (Chain)this.chainRepository.getReferenceById(chainId)).isUnsavedChanges()) {
            chain.setLastImportHash("0");
            chain.setUnsavedChanges(true);
            this.chainRepository.save((Object)chain);
        }
    }

    private String getChainIdFromElement(ChainElement chainElement) {
        if (chainElement.getChain() != null) {
            return chainElement.getChain().getId();
        }
        return null;
    }

    private String extractChainIdFromChainDiff(ChainDiff chainDiff) {
        return this.extractChainIdFromElementList(chainDiff.getCreatedElements()).or(() -> this.extractChainIdFromElementList(chainDiff.getUpdatedElements())).or(() -> this.extractChainIdFromElementList(chainDiff.getRemovedElements())).or(() -> this.extractChainIdFromDependencyList(chainDiff.getCreatedDependencies())).or(() -> this.extractChainIdFromDependencyList(chainDiff.getRemovedDependencies())).orElse(null);
    }

    private Optional<String> extractChainIdFromElementList(List<ChainElement> elements) {
        if (!elements.isEmpty()) {
            return Optional.ofNullable(this.getChainIdFromElement(elements.get(0)));
        }
        return Optional.empty();
    }

    private Optional<String> extractChainIdFromDependencyList(List<Dependency> dependencies) {
        if (!dependencies.isEmpty()) {
            Dependency dependency = dependencies.get(0);
            return Optional.ofNullable(this.getChainIdFromElement(dependency.getElementFrom() != null ? dependency.getElementFrom() : dependency.getElementTo()));
        }
        return Optional.empty();
    }
}

