/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.model;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.qubership.integration.platform.catalog.persistence.configs.entity.AbstractEntity;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Dependency;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.util.DistinctByKey;

public class ChainDiff {
    private List<ChainElement> createdElements = new ArrayList<ChainElement>();
    private List<ChainElement> updatedElements = new ArrayList<ChainElement>();
    private List<ChainElement> removedElements = new ArrayList<ChainElement>();
    private String createdDefaultSwimlaneId;
    private String createdReuseSwimlaneId;
    private List<Dependency> createdDependencies = new ArrayList<Dependency>();
    private List<Dependency> removedDependencies = new ArrayList<Dependency>();

    public void addCreatedElement(ChainElement chainElement) {
        this.addIfNotPresent(this.createdElements, chainElement);
    }

    public void addCreatedElements(List<ChainElement> chainElements) {
        chainElements.forEach(element -> this.addIfNotPresent(this.createdElements, (ChainElement)element));
    }

    public void addUpdatedElement(ChainElement chainElement) {
        this.addIfNotPresent(this.updatedElements, chainElement);
    }

    public void addUpdatedElements(List<ChainElement> chainElements) {
        chainElements.forEach(element -> this.addIfNotPresent(this.updatedElements, (ChainElement)element));
    }

    public void addRemovedElement(ChainElement chainElement) {
        this.addIfNotPresent(this.removedElements, chainElement);
    }

    public void addRemovedElements(List<ChainElement> chainElements) {
        chainElements.forEach(element -> this.addIfNotPresent(this.removedElements, (ChainElement)element));
    }

    public void setCreatedDefaultSwimlaneId(String createdDefaultSwimlaneId) {
        this.createdDefaultSwimlaneId = createdDefaultSwimlaneId;
    }

    public void setCreatedReuseSwimlaneId(String createdReuseGroupId) {
        this.createdReuseSwimlaneId = createdReuseGroupId;
    }

    public void addCreatedDependency(Dependency dependency) {
        this.addIfNotPresent(this.createdDependencies, dependency);
    }

    public void addCreatedDependencies(List<Dependency> dependencies) {
        dependencies.forEach(dependency -> this.addIfNotPresent(this.createdDependencies, (Dependency)dependency));
    }

    public void addRemovedDependency(Dependency dependency) {
        this.addIfNotPresent(this.removedDependencies, dependency);
    }

    public void addRemovedDependencies(List<Dependency> dependencies) {
        dependencies.forEach(dependency -> this.addIfNotPresent(this.removedDependencies, (Dependency)dependency));
    }

    public void merge(ChainDiff chainDelta) {
        this.createdElements = this.mergeElements(this.createdElements, chainDelta.createdElements);
        this.updatedElements = this.mergeElements(this.updatedElements, chainDelta.updatedElements);
        this.removedElements = this.mergeElements(this.removedElements, chainDelta.removedElements);
        this.createdDependencies = this.mergeDependencies(this.createdDependencies, chainDelta.createdDependencies);
        this.removedDependencies = this.mergeDependencies(this.removedDependencies, chainDelta.removedDependencies);
    }

    private void addIfNotPresent(List<ChainElement> elements, ChainElement newElement) {
        if (!elements.contains(newElement) || elements.stream().noneMatch(it -> it.getId().equals(newElement.getId()))) {
            elements.add(newElement);
        }
    }

    private void addIfNotPresent(List<Dependency> dependencies, Dependency newDependency) {
        if (!dependencies.contains(newDependency) || dependencies.stream().noneMatch(it -> it.getId().equals(newDependency.getId()))) {
            dependencies.add(newDependency);
        }
    }

    private List<ChainElement> mergeElements(List<ChainElement> right, List<ChainElement> left) {
        return Stream.concat(right.stream(), left.stream()).filter(DistinctByKey.newInstance(AbstractEntity::getId)).collect(Collectors.toList());
    }

    private List<Dependency> mergeDependencies(List<Dependency> right, List<Dependency> left) {
        return Stream.concat(right.stream(), left.stream()).filter(DistinctByKey.newInstance(Dependency::getId)).collect(Collectors.toList());
    }

    @Generated
    public List<ChainElement> getCreatedElements() {
        return this.createdElements;
    }

    @Generated
    public List<ChainElement> getUpdatedElements() {
        return this.updatedElements;
    }

    @Generated
    public List<ChainElement> getRemovedElements() {
        return this.removedElements;
    }

    @Generated
    public String getCreatedDefaultSwimlaneId() {
        return this.createdDefaultSwimlaneId;
    }

    @Generated
    public String getCreatedReuseSwimlaneId() {
        return this.createdReuseSwimlaneId;
    }

    @Generated
    public List<Dependency> getCreatedDependencies() {
        return this.createdDependencies;
    }

    @Generated
    public List<Dependency> getRemovedDependencies() {
        return this.removedDependencies;
    }
}

