/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.rest.v1.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.qubership.integration.platform.catalog.exception.ChainDifferenceClientException;
import org.qubership.integration.platform.catalog.mapping.EntityDiffResponseMapper;
import org.qubership.integration.platform.catalog.model.dto.chain.EntityDifferenceResponse;
import org.qubership.integration.platform.catalog.model.dto.system.UsedSystem;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.catalog.service.difference.ChainDifferenceRequest;
import org.qubership.integration.platform.catalog.service.difference.ChainDifferenceService;
import org.qubership.integration.platform.catalog.service.difference.EntityDifferenceResult;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.chain.ChainDTO;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.chain.ChainRequest;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.chain.ChainResponse;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.chain.ChainsBySpecificationGroup;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.chain.ChainsCountResponse;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.chain.MigratedChainDTO;
import org.qubership.integration.platform.designtime.catalog.rest.v1.mapping.ChainLabelsMapper;
import org.qubership.integration.platform.designtime.catalog.rest.v1.mapping.ChainMapper;
import org.qubership.integration.platform.designtime.catalog.rest.v1.mapping.MigratedChainMapper;
import org.qubership.integration.platform.designtime.catalog.service.ChainService;
import org.qubership.integration.platform.designtime.catalog.service.migration.ChainMigrationService;
import org.qubership.integration.platform.designtime.catalog.service.migration.MigratedChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/chains"}, produces={"application/json"})
@CrossOrigin(origins={"*"})
@Tag(name="chain-controller", description="Chain Controller")
public class ChainController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ChainController.class);
    private final ChainService chainService;
    private final ChainDifferenceService chainDifferenceService;
    private final ChainMapper chainMapper;
    private final ChainMigrationService chainMigrationService;
    private final MigratedChainMapper migratedChainMapper;
    private final ChainLabelsMapper chainLabelsMapper;
    private final EntityDiffResponseMapper entityDiffResponseMapper;

    @Autowired
    public ChainController(ChainService chainService, ChainDifferenceService chainDifferenceService, ChainMapper chainMapper, ChainMigrationService chainMigrationService, MigratedChainMapper migratedChainMapper, ChainLabelsMapper chainLabelsMapper, EntityDiffResponseMapper entityDiffResponseMapper) {
        this.chainService = chainService;
        this.chainDifferenceService = chainDifferenceService;
        this.chainMapper = chainMapper;
        this.chainMigrationService = chainMigrationService;
        this.migratedChainMapper = migratedChainMapper;
        this.chainLabelsMapper = chainLabelsMapper;
        this.entityDiffResponseMapper = entityDiffResponseMapper;
    }

    @GetMapping
    @Operation(description="Get list of all chains and folders without chain elements")
    public ResponseEntity<List<ChainResponse>> findAllLight() {
        if (log.isDebugEnabled()) {
            log.debug("Request to receive all previews");
        }
        List<Chain> chains = this.chainService.findAll();
        List<ChainResponse> chainsDto = this.chainMapper.asChainResponseLight(chains);
        return ResponseEntity.ok(chainsDto);
    }

    @GetMapping(value={"/{chainId}"})
    @Operation(description="Find chain with its elements")
    public ResponseEntity<ChainDTO> findById(@PathVariable @Parameter(description="Chain id") String chainId) {
        if (log.isDebugEnabled()) {
            log.debug("Request to receive info about chain with id: {}", (Object)chainId);
        }
        Chain chain = this.chainService.findById(chainId);
        ChainDTO response = this.chainMapper.asDTO(chain);
        Map<String, String> navigationPath = this.chainService.provideNavigationPath(chainId);
        response.setNavigationPath(navigationPath);
        response.setContainsDeprecatedContainers(this.chainMigrationService.containsDeprecatedContainers(chain));
        response.setContainsDeprecatedElements(this.chainService.containsDeprecatedElements(chain));
        response.setContainsUnsupportedElements(this.chainService.containsUnsupportedElements(chain));
        return ResponseEntity.ok((Object)((Object)response));
    }

    @GetMapping(value={"/{systemId}/{operationId}"})
    @Operation(description="Find chains (without elements) which elements is using specified service and operation")
    public ResponseEntity<List<ChainResponse>> findBySystemIdAndOperationId(@PathVariable @Parameter(description="Service id") String systemId, @PathVariable @Parameter(description="Specification operation id") String operationId) {
        if (log.isDebugEnabled()) {
            log.debug("Request to find chains by system {} and operation {}", (Object)systemId, (Object)operationId);
        }
        List<Chain> chains = this.chainService.findBySystemAndOperationId(systemId, operationId);
        List<ChainResponse> chainsDto = this.chainMapper.asChainResponseLight(chains);
        return ResponseEntity.ok(chainsDto);
    }

    @GetMapping(value={"/{systemId}/model/{modelId}"})
    @Operation(description="Find chains (without elements) which elements is using specified service and specification")
    public ResponseEntity<List<ChainResponse>> findBySystemIdAndModelId(@PathVariable @Parameter(description="Service id") String systemId, @PathVariable @Parameter(description="Specification id") String modelId) {
        if (log.isDebugEnabled()) {
            log.debug("Request to find chains by system {} and model {}", (Object)systemId, (Object)modelId);
        }
        List<Chain> chains = this.chainService.findBySystemAndModelId(systemId, modelId);
        List<ChainResponse> chainsDto = this.chainMapper.asChainResponseLight(chains);
        return ResponseEntity.ok(chainsDto);
    }

    @GetMapping(value={"/{systemId}/specificationGroup/{groupId}"})
    @Operation(description="Find chains (without elements) which elements is using specified service and specification group")
    public ResponseEntity<List<ChainResponse>> findBySystemIdAndSpecificationGroupId(@PathVariable @Parameter(description="Service id") String systemId, @PathVariable @Parameter(description="Specification group id") String groupId) {
        if (log.isDebugEnabled()) {
            log.debug("Request to find chains by system {} and specification group {}", (Object)systemId, (Object)groupId);
        }
        List<Chain> chains = this.chainService.findBySystemAndGroupId(systemId, groupId);
        List<ChainResponse> chainsDto = this.chainMapper.asChainResponseLight(chains);
        return ResponseEntity.ok(chainsDto);
    }

    @GetMapping(value={"/{systemId}/specificationGroup"})
    @Operation(description="Find chains (without elements) which elements is using specified service grouped by specification group")
    public ResponseEntity<List<ChainsBySpecificationGroup>> findBySystemIdGroupBySpecificationGroup(@PathVariable @Parameter(description="Service id") String systemId) {
        if (log.isDebugEnabled()) {
            log.debug("Request to find chains by system {} with specification groups information", (Object)systemId);
        }
        Map<String, List<Chain>> specGroupsChains = this.chainService.findBySystemIdGroupBySpecificationGroup(systemId);
        List<ChainsBySpecificationGroup> chainsDto = this.chainMapper.asChainsBySpecificationGroup(specGroupsChains);
        return ResponseEntity.ok(chainsDto);
    }

    @GetMapping(value={"/systems/{systemId}"})
    @Operation(description="Find chains (with or without elements) which elements is using specified service")
    public ResponseEntity<Object> findBySystemId(@PathVariable @Parameter(description="Service id") String systemId, @RequestParam(required=false, defaultValue="light") @Parameter(description="If \"light\" was passed - response will be without chain elements. Otherwise elements will be included in response.") String mode) {
        if (log.isDebugEnabled()) {
            log.debug("Request to find chains by system {}", (Object)systemId);
        }
        if (mode.equals("light")) {
            List chains = this.chainService.findBySystemId(systemId);
            List<ChainResponse> chainsDto = this.chainMapper.asChainResponseLight(chains);
            return ResponseEntity.ok(chainsDto);
        }
        List chains = this.chainService.findBySystemId(systemId);
        List<ChainDTO> chainsDto = this.chainMapper.asDTO(chains);
        return ResponseEntity.ok(chainsDto);
    }

    @GetMapping(value={"/used-systems"})
    @Operation(description="Get services and specifications used by specified chains")
    public ResponseEntity<List<UsedSystem>> getUsedSystemIdsByChainIds(@RequestParam(required=false) @Parameter(description="Chain ids separated by comma") List<String> chainIds) {
        return ResponseEntity.ok(this.chainService.getUsedSystemIdsByChainIds(chainIds));
    }

    @GetMapping(value={"/names"})
    @Operation(description="Get map of chain ids and related chain name")
    public ResponseEntity<Map<String, String>> getNamesMapByChainIds(@RequestParam @Parameter(description="Chain ids separated by comma") Set<String> chainIds) {
        return ResponseEntity.ok(this.chainService.getNamesMapByChainIds(chainIds));
    }

    @RequestMapping(method={RequestMethod.HEAD}, value={"/{chainId}"})
    @Operation(description="Find chain by id if it exists", extensions={@Extension(properties={@ExtensionProperty(name="x-api-kind", value="bwc")})})
    public ResponseEntity<Chain> findExistingChain(@PathVariable String chainId) {
        return ResponseEntity.ok((Object)this.chainService.findById(chainId));
    }

    @PostMapping
    @Operation(description="Create a new chain")
    public ResponseEntity<ChainResponse> create(@org.springframework.web.bind.annotation.RequestBody @Parameter(description="Chain creation request object") ChainRequest request) {
        String parentFolderId = request.getParentId();
        log.info("Request to create new chain under folder: {}", (Object)parentFolderId);
        Chain chain = this.chainMapper.asEntity(request);
        chain = this.chainService.save(chain, parentFolderId);
        ChainResponse response = this.chainMapper.asChainResponseLight(chain);
        return ResponseEntity.ok((Object)((Object)response));
    }

    @PutMapping(value={"/{chainId}"})
    @Operation(description="Update existing chain")
    public ResponseEntity<ChainDTO> update(@PathVariable @Parameter(description="Chain id") String chainId, @org.springframework.web.bind.annotation.RequestBody @Parameter(description="Chain creation request object") ChainRequest request) {
        log.info("Request to update chain with id: {}", (Object)chainId);
        String parentFolderId = request.getParentId();
        Chain chain = this.chainService.findById(chainId);
        this.chainMapper.mergeWithoutLabels(chain, request);
        chain = this.chainService.update(chain, this.chainLabelsMapper.asEntities(request.getLabels()), parentFolderId);
        ChainDTO response = this.chainMapper.asDTO(chain);
        Map<String, String> navigationPath = this.chainService.provideNavigationPath(chainId);
        response.setNavigationPath(navigationPath);
        return ResponseEntity.ok((Object)((Object)response));
    }

    @DeleteMapping(value={"/{chainId}"})
    @Operation(description="Delete chain")
    public ResponseEntity<Void> deleteById(@PathVariable @Parameter(description="Chain id") String chainId) {
        log.info("Request to remove chain with id: {}", (Object)chainId);
        this.chainService.deleteById(chainId);
        return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/{chainId}/copy"})
    @Operation(description="Copy existing chain to a specified folder")
    public ResponseEntity<ChainResponse> copy(@PathVariable @Parameter(description="Chain id") String chainId, @RequestParam(required=false, defaultValue="#{null}") @Parameter(description="Target folder id") String targetFolderId) {
        log.info("Request to copy chain with id: {}, target folder id: {}", (Object)chainId, (Object)targetFolderId);
        Chain chainCopy = this.chainService.copy(chainId, targetFolderId);
        ChainResponse response = this.chainMapper.asChainResponseLight(chainCopy);
        return ResponseEntity.ok((Object)((Object)response));
    }

    @PostMapping(value={"/{chainId}/duplicate"})
    @Operation(description="Copy existing chain to the same folder")
    public ResponseEntity<ChainResponse> duplicate(@PathVariable @Parameter(description="Chain id") String chainId) {
        log.info("Request to duplicate chain with id: {}", (Object)chainId);
        Chain chainCopy = this.chainService.duplicate(chainId);
        ChainResponse response = this.chainMapper.asChainResponseLight(chainCopy);
        return ResponseEntity.ok((Object)((Object)response));
    }

    @PostMapping(value={"/{chainId}/move"})
    @Operation(description="Move existing chain to a specified folder")
    public ResponseEntity<ChainResponse> move(@PathVariable @Parameter(description="Chain id") String chainId, @RequestParam(required=false, defaultValue="#{null}") @Parameter(description="Target folder id") String targetFolderId) {
        log.info("Request to move chain with id: {}, target folder id: {}", (Object)chainId, (Object)targetFolderId);
        Chain chainCopy = this.chainService.move(chainId, targetFolderId);
        ChainResponse response = this.chainMapper.asChainResponseLight(chainCopy);
        return ResponseEntity.ok((Object)((Object)response));
    }

    @PatchMapping(value={"/{chainId}/migrate"})
    @Operation(description="Initiate migrate process for a chain to replace old deprecated elements with new ones")
    public ResponseEntity<MigratedChainDTO> migrate(@PathVariable @Parameter(description="Chain id") String chainId) {
        if (log.isDebugEnabled()) {
            log.debug("Request to migrate chain with id: {}", (Object)chainId);
        }
        MigratedChain migratedChain = this.chainMigrationService.migrateChain(chainId);
        MigratedChainDTO response = this.migratedChainMapper.asDTO(migratedChain);
        response.getChain().setContainsDeprecatedElements(this.chainService.containsDeprecatedElements(migratedChain.getChain()));
        response.getChain().setContainsUnsupportedElements(this.chainService.containsUnsupportedElements(migratedChain.getChain()));
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/count"})
    @Operation(description="Get chains total count")
    public ResponseEntity<ChainsCountResponse> getChainsTotalCount() {
        return ResponseEntity.ok((Object)new ChainsCountResponse(this.chainService.getChainsCount()));
    }

    @PostMapping(value={"/diff"})
    @Operation(description="Find differences between chains/snapshots", responses={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=EntityDifferenceResponse.class))})})
    public ResponseEntity<EntityDifferenceResponse> difference(@org.springframework.web.bind.annotation.RequestBody @RequestBody(description="Chain difference request", content={@Content(schema=@Schema(implementation=ChainDifferenceRequest.class))}) @Validated ChainDifferenceRequest chainDiffRequest, BindingResult bindingResult) {
        if (log.isDebugEnabled()) {
            log.debug("Request to get differences between entities: {}, {}", (Object)Optional.ofNullable(chainDiffRequest.getLeftSnapshotId()).orElse(chainDiffRequest.getLeftChainId()), (Object)Optional.ofNullable(chainDiffRequest.getRightSnapshotId()).orElse(chainDiffRequest.getRightChainId()));
        }
        if (bindingResult.hasFieldErrors()) {
            throw new ChainDifferenceClientException("Diff request validation failed: " + String.valueOf(bindingResult.getFieldErrors().stream().map(DefaultMessageSourceResolvable::getDefaultMessage).toList()));
        }
        EntityDifferenceResult diffResult = this.chainDifferenceService.findChainsDifferences(chainDiffRequest);
        return ResponseEntity.ok((Object)this.entityDiffResponseMapper.asResponse(diffResult));
    }
}

