/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.rest.v1.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.qubership.integration.platform.catalog.model.designgenerator.DiagramMode;
import org.qubership.integration.platform.catalog.model.designgenerator.ElementsSequenceDiagram;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.chain.design.GenerateChainDesignRequest;
import org.qubership.integration.platform.designtime.catalog.service.designgenerator.DesignGeneratorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/design-generator/chains/{chainId}"}, produces={"application/json"})
@CrossOrigin(origins={"*"})
@Tag(name="chain-design-controller", description="Chain Design Controller")
public class ChainDesignController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ChainDesignController.class);
    private final DesignGeneratorService designGeneratorService;

    @Autowired
    public ChainDesignController(DesignGeneratorService designGeneratorService) {
        this.designGeneratorService = designGeneratorService;
    }

    @Deprecated(since="24.3")
    @GetMapping
    @Operation(description="Generate chain sequence diagram")
    public ResponseEntity<ElementsSequenceDiagram> generateChainSequenceDiagram(@PathVariable @Parameter(description="Chain id") String chainId) {
        Map<DiagramMode, ElementsSequenceDiagram> elementsSequenceDiagrams = this.designGeneratorService.generateChainSequenceDiagram(chainId, List.of(DiagramMode.FULL));
        return ResponseEntity.ok((Object)elementsSequenceDiagrams.get(DiagramMode.FULL));
    }

    @PostMapping
    @Operation(description="Generate chain sequence diagrams")
    public ResponseEntity<Map<DiagramMode, ElementsSequenceDiagram>> generateChainSequenceDiagrams(@PathVariable @Parameter(description="Chain id") String chainId, @RequestBody @Parameter(description="Design generation request") GenerateChainDesignRequest request) {
        return ResponseEntity.ok(this.designGeneratorService.generateChainSequenceDiagram(chainId, request.getDiagramModes()));
    }

    @Deprecated(since="24.3")
    @GetMapping(value={"/snapshots/{snapshotId}"})
    @Operation(description="Generate chain sequence diagram from specified snapshot")
    public ResponseEntity<ElementsSequenceDiagram> generateSnapshotSequenceDiagram(@PathVariable @Parameter(description="Chain id") String chainId, @PathVariable @Parameter(description="Snapshot id of specified chain") String snapshotId) {
        Map<DiagramMode, ElementsSequenceDiagram> elementsSequenceDiagrams = this.designGeneratorService.generateSnapshotSequenceDiagram(chainId, snapshotId, List.of(DiagramMode.FULL));
        return ResponseEntity.ok((Object)elementsSequenceDiagrams.get(DiagramMode.FULL));
    }

    @PostMapping(value={"/snapshots/{snapshotId}"})
    @Operation(description="Generate chain sequence diagrams from specified snapshot")
    public ResponseEntity<Map<DiagramMode, ElementsSequenceDiagram>> generateSnapshotSequenceDiagrams(@PathVariable @Parameter(description="Chain id") String chainId, @PathVariable @Parameter(description="Snapshot id of specified chain") String snapshotId, @RequestBody @Parameter(description="Design generation request") GenerateChainDesignRequest request) {
        return ResponseEntity.ok(this.designGeneratorService.generateSnapshotSequenceDiagram(chainId, snapshotId, request.getDiagramModes()));
    }
}

