/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.rest.v1.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import lombok.Generated;
import org.qubership.integration.platform.catalog.model.dto.chain.ElementsFilterDTO;
import org.qubership.integration.platform.catalog.model.library.ElementDescriptor;
import org.qubership.integration.platform.catalog.model.library.LibraryElements;
import org.qubership.integration.platform.catalog.service.library.LibraryElementsService;
import org.qubership.integration.platform.designtime.catalog.rest.v1.mapping.ElementMapper;
import org.qubership.integration.platform.designtime.catalog.service.ElementService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/library"}, produces={"application/json"})
@CrossOrigin(origins={"*"})
@Tag(name="element-library-controller", description="Element Library Controller")
public class ElementLibraryController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ElementLibraryController.class);
    private final LibraryElementsService libraryElementsService;
    private final ElementService elementService;
    private final ElementMapper elementMapper;

    @Autowired
    public ElementLibraryController(LibraryElementsService libraryElementsService, ElementService elementService, ElementMapper elementMapper) {
        this.libraryElementsService = libraryElementsService;
        this.elementService = elementService;
        this.elementMapper = elementMapper;
    }

    @GetMapping
    @Operation(description="Get all library elements (descriptors)")
    public ResponseEntity<LibraryElements> getElementsHierarchy() {
        return ResponseEntity.ok((Object)this.libraryElementsService.getElementsHierarchy());
    }

    @GetMapping(value={"/{name}"})
    @Operation(description="Get library element by it's inner type name")
    public ResponseEntity<ElementDescriptor> getLibraryElement(@PathVariable @Parameter(description="Inner type name") String name) {
        ElementDescriptor element;
        if (log.isDebugEnabled()) {
            log.debug("Request to receive element with name: {}", (Object)name);
        }
        if ((element = this.libraryElementsService.getElementDescriptor(name)) != null) {
            return ResponseEntity.ok((Object)element);
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/elements/types"})
    @Operation(description="Find all library elements inner types and title names")
    public ResponseEntity<List<ElementsFilterDTO>> findAllUsingElementsTypes() {
        return ResponseEntity.ok((Object)this.libraryElementsService.getElementsTitles(this.elementService.findAllUsingTypes()));
    }
}

