/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.rest.v1.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import lombok.Generated;
import org.qubership.integration.platform.designtime.catalog.service.ElementModificationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/chains/{chainId}/elements/properties-modification"}, produces={"application/json"})
@CrossOrigin(origins={"*"})
@Tag(name="element-modification-controller", description="Element Modification Controller")
public class ElementModificationController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ElementModificationController.class);
    private final ElementModificationService elementModificationService;

    @Autowired
    public ElementModificationController(ElementModificationService elementModificationService) {
        this.elementModificationService = elementModificationService;
    }

    @PutMapping
    @Operation(description="Change specified http triggers type to implemented with specified specification group")
    public ResponseEntity<Void> modifyHttpTriggerProperties(@PathVariable(required=false) @Parameter(description="Chain id") String chainId, @RequestParam @Parameter(description="Specification group id") String specificationGroupId, @RequestParam @Parameter(description="List of http trigger elements separated by comma") List<String> httpTriggerIds) {
        this.elementModificationService.makeHttpTriggersTypeImplemented(httpTriggerIds, specificationGroupId);
        return ResponseEntity.noContent().build();
    }
}

