/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.rest.v1.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import lombok.Generated;
import org.qubership.integration.platform.catalog.mapping.EnvironmentMapper;
import org.qubership.integration.platform.catalog.model.dto.system.EnvironmentDTO;
import org.qubership.integration.platform.catalog.model.dto.system.EnvironmentRequestDTO;
import org.qubership.integration.platform.catalog.model.system.EnvironmentLabel;
import org.qubership.integration.platform.catalog.model.system.IntegrationSystemType;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.Environment;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.IntegrationSystem;
import org.qubership.integration.platform.designtime.catalog.exception.exceptions.BadRequestException;
import org.qubership.integration.platform.designtime.catalog.service.EnvironmentService;
import org.qubership.integration.platform.designtime.catalog.service.SystemService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Validated
@CrossOrigin(origins={"*"})
@RequestMapping(value={"/v1/systems/{systemId}/environments"})
@Tag(name="environment-controller", description="Environment Controller")
public class EnvironmentController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EnvironmentController.class);
    private static final String INTERNAL_SYSTEM_ENVIRONMENT_UNIQUE_MESSAGE = "Can't put more than one environment to 'internal' system";
    private static final String UNIQUE_LABEL_WITHIN_SINGLE_SYSTEM_MESSAGE = "Label should be unique within single system: ";
    private final EnvironmentService environmentService;
    private final SystemService systemService;
    private final EnvironmentMapper environmentMapper;

    @Autowired
    public EnvironmentController(EnvironmentService environmentService, EnvironmentMapper environmentMapper, SystemService systemService) {
        this.environmentService = environmentService;
        this.environmentMapper = environmentMapper;
        this.systemService = systemService;
    }

    @GetMapping(produces={"application/json"})
    @Operation(description="Get all environments for specified service")
    public List<EnvironmentDTO> getEnvironments(@PathVariable @Parameter(description="Service id") String systemId) {
        if (log.isDebugEnabled()) {
            log.debug("Request to get environments for system: {}", (Object)systemId);
        }
        return this.environmentMapper.toDTOs(this.environmentService.getEnvironmentsForSystem(systemId));
    }

    @GetMapping(value={"/{environmentId}"}, produces={"application/json"})
    @Operation(description="Get specific environment from service")
    public EnvironmentDTO getEnvironment(@PathVariable @Parameter(description="Service id") String systemId, @PathVariable @Parameter(description="Environment id") String environmentId) {
        if (log.isDebugEnabled()) {
            log.debug("Request to get environments for system: {}", (Object)systemId);
        }
        return this.environmentMapper.toDTO(this.environmentService.getByIdForSystem(systemId, environmentId));
    }

    @PostMapping
    @Operation(description="Create new environment for a service")
    public ResponseEntity<EnvironmentDTO> createEnvironment(@PathVariable @Parameter(description="Service id") String systemId, @RequestBody @Parameter(description="Request object for environment creation") EnvironmentRequestDTO environmentRequestDTO) {
        log.info("Request to create environment for system: {}", (Object)systemId);
        this.checkEnvironmentLabels(systemId, environmentRequestDTO.getLabels());
        if (environmentRequestDTO.getProperties() != null) {
            environmentRequestDTO.setProperties(environmentRequestDTO.getProperties());
        }
        Environment environment = this.environmentMapper.toEnvironment(environmentRequestDTO);
        IntegrationSystem system = this.systemService.getByIdOrNull(systemId);
        if (IntegrationSystemType.INTERNAL.equals((Object)system.getIntegrationSystemType()) && system.getEnvironments().size() > 0) {
            throw new BadRequestException(INTERNAL_SYSTEM_ENVIRONMENT_UNIQUE_MESSAGE);
        }
        environment = this.environmentService.create(environment, system);
        return new ResponseEntity((Object)this.environmentMapper.toDTO(environment), (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/{environmentId}"}, produces={"application/json"})
    @Operation(description="Update existing environment of a service")
    public ResponseEntity<EnvironmentDTO> updateEnvironment(@PathVariable @Parameter(description="Service id") String systemId, @PathVariable @Parameter(description="Environment id") String environmentId, @RequestBody @Parameter(description="Request object for environment modifying") EnvironmentRequestDTO environmentRequestDTO) {
        log.info("Request to update environment {} for system {}", (Object)environmentId, (Object)systemId);
        Environment environment = this.environmentService.getByIdForSystemOrElseNull(systemId, environmentId);
        if (environment != null) {
            this.checkEnvironmentLabels(systemId, environmentRequestDTO.getLabels(), environmentId);
            environmentRequestDTO.setProperties(environmentRequestDTO.getProperties());
            this.environmentMapper.merge(environmentRequestDTO, environment);
            environment = this.environmentService.update(environment);
            return ResponseEntity.ok((Object)this.environmentMapper.toDTO(environment));
        }
        return this.createEnvironment(systemId, environmentRequestDTO);
    }

    @DeleteMapping(value={"/{environmentId}"})
    @Operation(description="Delete existing environment")
    public void deleteEnvironment(@PathVariable @Parameter(description="Service id") String systemId, @PathVariable @Parameter(description="Environment id") String environmentId) {
        log.info("Request to delete environment {} for system {}", (Object)environmentId, (Object)systemId);
        this.environmentService.deleteEnvironment(systemId, environmentId);
    }

    private void checkEnvironmentLabels(String systemId, List<EnvironmentLabel> labels, String excludeEnvironmentId) {
        if (labels == null) {
            return;
        }
        for (EnvironmentLabel label : labels) {
            List<Environment> labelEnvs = this.environmentService.getEnvironmentsByLabel(systemId, label);
            if (labelEnvs.isEmpty() || excludeEnvironmentId != null && labelEnvs.size() == 1 && labelEnvs.get(0).getId().equals(excludeEnvironmentId)) continue;
            throw new BadRequestException(UNIQUE_LABEL_WITHIN_SINGLE_SYSTEM_MESSAGE + String.valueOf(label));
        }
    }

    private void checkEnvironmentLabels(String systemId, List<EnvironmentLabel> labels) {
        this.checkEnvironmentLabels(systemId, labels, null);
    }
}

