/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.rest.v1.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import lombok.Generated;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.MaskedField;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.masking.MaskedFieldDTO;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.masking.MaskedFieldsResponse;
import org.qubership.integration.platform.designtime.catalog.rest.v1.mapping.MaskedFieldsMapper;
import org.qubership.integration.platform.designtime.catalog.service.ChainService;
import org.qubership.integration.platform.designtime.catalog.service.MaskedFieldsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/chains/{chainId}/masking"})
@CrossOrigin(origins={"*"})
@Tag(name="masked-fields-controller", description="Masked Fields Controller")
public class MaskedFieldsController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MaskedFieldsController.class);
    private final ChainService chainService;
    private final MaskedFieldsService maskedService;
    private final MaskedFieldsMapper mapper;

    @Autowired
    public MaskedFieldsController(MaskedFieldsService maskedService, ChainService chainService, MaskedFieldsMapper mapper) {
        this.maskedService = maskedService;
        this.chainService = chainService;
        this.mapper = mapper;
    }

    @GetMapping
    @Operation(description="Get masked fields for specified chain")
    public ResponseEntity<MaskedFieldsResponse> findByChainId(@PathVariable @Parameter(description="Chain id") String chainId) {
        if (log.isDebugEnabled()) {
            log.debug("Request to find masked fields for chain: {}", (Object)chainId);
        }
        return ResponseEntity.ok((Object)this.mapper.asResponse(this.chainService.findById(chainId)));
    }

    @PostMapping
    @Operation(description="Create new masked field for specified chain")
    public ResponseEntity<MaskedFieldDTO> createField(@PathVariable @Parameter(description="Chain id") String chainId, @RequestBody @Parameter(description="Masked field data") MaskedFieldDTO maskedField) {
        log.info("Request to create masked fields for chain: {}", (Object)chainId);
        return ResponseEntity.ok((Object)this.mapper.asDto(this.maskedService.create(this.mapper.asEntity(this.chainService.findById(chainId), maskedField))));
    }

    @PostMapping(value={"/field"})
    @Operation(description="Bulk delete masked fields from a chain")
    public ResponseEntity<Void> deleteFields(@PathVariable @Parameter(description="Chain id") String chainId, @RequestBody @Parameter(description="Masked field IDs") List<String> maskedFieldIds) {
        log.info("Request to delete masked fields for chain: {}, field IDs: {}", (Object)chainId, maskedFieldIds);
        this.maskedService.deleteAllByIds(maskedFieldIds);
        return ResponseEntity.noContent().build();
    }

    @DeleteMapping(value={"/field/{fieldId}"})
    @Operation(description="Delete specified masked field from a chain")
    public ResponseEntity<Void> deleteField(@PathVariable @Parameter(description="Chain id") String chainId, @PathVariable @Parameter(description="Masked field id") String fieldId) {
        log.info("Request to delete masked field {} for chain: {}", (Object)fieldId, (Object)chainId);
        this.maskedService.delete(fieldId);
        return ResponseEntity.noContent().build();
    }

    @PutMapping(value={"/field/{fieldId}"})
    @Operation(description="Update specified masked field in a chain")
    public ResponseEntity<MaskedFieldDTO> updateField(@PathVariable @Parameter(description="Chain id") String chainId, @PathVariable @Parameter(description="Masked field id") String fieldId, @RequestBody @Parameter(description="Masked field data") MaskedFieldDTO maskedField) {
        log.info("Request to update masked field {} for chain: {}", (Object)fieldId, (Object)chainId);
        MaskedField entity = this.maskedService.findById(fieldId);
        entity.merge(this.mapper.asEntity(maskedField));
        return ResponseEntity.ok((Object)this.mapper.asDto(this.maskedService.update(entity)));
    }
}

