/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.rest.v1.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.URI;
import java.util.List;
import lombok.Generated;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.SpecificationGroup;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.SpecificationGroupCreationRequestDTO;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.SpecificationGroupDTO;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.SpecificationGroupRequestDTO;
import org.qubership.integration.platform.designtime.catalog.rest.v1.mapping.SpecificationGroupMapper;
import org.qubership.integration.platform.designtime.catalog.service.SpecificationGroupService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@RestController
@CrossOrigin(origins={"*"})
@RequestMapping(value={"/v1/specificationGroups"})
@Tag(name="specification-group-controller", description="Specification Group Controller")
public class SpecificationGroupController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpecificationGroupController.class);
    private final SpecificationGroupService specificationGroupService;
    private final SpecificationGroupMapper specificationGroupMapper;

    @Autowired
    public SpecificationGroupController(SpecificationGroupService specificationGroupService, SpecificationGroupMapper specificationGroupMapper) {
        this.specificationGroupService = specificationGroupService;
        this.specificationGroupMapper = specificationGroupMapper;
    }

    @GetMapping(produces={"application/json"})
    @Operation(description="Get all specification groups for specified service")
    public ResponseEntity<List<SpecificationGroupDTO>> getSpecificationGroups(@RequestParam @Parameter(description="Service id") String systemId) {
        return ResponseEntity.ok(this.specificationGroupMapper.toSpecificationGroupDTOs(this.specificationGroupService.getSpecificationGroups(systemId)));
    }

    @DeleteMapping(value={"/{specificationGroupId}"}, produces={"application/json"})
    @Operation(description="Delete specification group")
    public void deleteSpecificationGroup(@PathVariable @Parameter(description="Specification group id") String specificationGroupId) {
        log.info("Request to delete specification group {}", (Object)specificationGroupId);
        this.specificationGroupService.delete(specificationGroupId);
    }

    @PatchMapping(value={"/{specificationGroupId}"}, produces={"application/json"})
    @Operation(description="Update synchronization toggle on a specification group")
    public ResponseEntity<SpecificationGroupDTO> updateSyncStatus(@PathVariable @Parameter(description="Specification group id") String specificationGroupId, @RequestBody @Parameter(description="Specification group modification object") SpecificationGroupRequestDTO specificationGroupDTO) {
        SpecificationGroup specificationGroup = this.specificationGroupService.getById(specificationGroupId);
        if (specificationGroup != null) {
            this.specificationGroupMapper.mergeWithoutLabels(specificationGroupDTO, specificationGroup);
            specificationGroup = this.specificationGroupService.update(specificationGroup, this.specificationGroupMapper.asLabelRequests(specificationGroupDTO.getLabels()));
            return ResponseEntity.ok((Object)this.specificationGroupMapper.toSpecificationGroupDTO(specificationGroup));
        }
        return ResponseEntity.badRequest().build();
    }

    @PostMapping
    @Operation(description="Create specification group")
    public ResponseEntity<SpecificationGroupDTO> createSpecificationGroup(@RequestBody @Parameter(description="Specification group create request object") SpecificationGroupCreationRequestDTO params) {
        SpecificationGroup specificationGroup = this.specificationGroupService.createAndSaveSpecificationGroup(params.getSystemId(), params.getName(), params.getDescription(), params.getUrl(), params.isSynchronization());
        SpecificationGroupDTO response = this.specificationGroupMapper.toSpecificationGroupDTO(specificationGroup);
        URI location = ServletUriComponentsBuilder.fromCurrentRequest().path("/{id}").buildAndExpand(new Object[]{response.getId()}).toUri();
        return ResponseEntity.created((URI)location).body((Object)response);
    }
}

