/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.rest.v1.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.qubership.integration.platform.catalog.model.system.OperationProtocol;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.IntegrationSystem;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.FilterRequestDTO;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.system.SystemDTO;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.system.SystemRequestDTO;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.system.SystemSearchRequestDTO;
import org.qubership.integration.platform.designtime.catalog.rest.v1.mapping.SystemMapper;
import org.qubership.integration.platform.designtime.catalog.service.SystemService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
@RequestMapping(value={"/v1/systems"})
@Tag(name="system-controller", description="System Controller")
public class SystemController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SystemController.class);
    private final SystemService systemService;
    private final SystemMapper systemMapper;

    @Autowired
    public SystemController(SystemService systemService, SystemMapper systemMapper) {
        this.systemService = systemService;
        this.systemMapper = systemMapper;
    }

    @GetMapping(produces={"application/json"})
    @Operation(description="Get all services")
    public List<SystemDTO> getSystems(@RequestParam(required=false, defaultValue="all") @Parameter(description="Filter services by type. If \"all\" specified - nothing will be excluded from the response.") String modelType, @RequestParam(required=false, defaultValue="false") @Parameter(description="Whether response will include specifications") boolean withSpec) {
        List<IntegrationSystem> systems = modelType.equals("all") ? (withSpec ? this.systemService.getNotDeprecatedWithSpecs() : this.systemService.getAll()) : this.systemService.getNotDeprecatedAndByModelType(OperationProtocol.receiveProtocolsFromType((String)modelType));
        return this.systemMapper.toResponseDTOs(systems);
    }

    @GetMapping(value={"/{systemId}"}, produces={"application/json"})
    @Operation(description="Get specific service")
    public SystemDTO getSystem(@PathVariable @Parameter(description="Service id") String systemId) {
        if (log.isDebugEnabled()) {
            log.debug("Request to get system {}", (Object)systemId);
        }
        return this.systemMapper.toDTO(this.systemService.findById(systemId));
    }

    @PostMapping(value={"/search"}, produces={"application/json"})
    @Operation(description="Search services request")
    public List<SystemDTO> searchSystems(@RequestBody @Parameter(description="Service search request object") SystemSearchRequestDTO systemSearchRequestDTO) {
        return this.systemMapper.toResponseDTOs(this.systemService.searchSystems(systemSearchRequestDTO));
    }

    @PostMapping(value={"/filter"}, produces={"application/json"})
    @Operation(description="Filter services request")
    public List<SystemDTO> filterSystems(@RequestBody @Parameter(description="Service filter request object") List<FilterRequestDTO> systemFilterRequestDTOList) {
        List<IntegrationSystem> systemsFilterResult = this.systemService.findByFilterRequest(systemFilterRequestDTOList);
        return this.systemMapper.toResponseDTOs(systemsFilterResult).stream().sorted(Comparator.comparing(SystemDTO::getName, String.CASE_INSENSITIVE_ORDER)).collect(Collectors.toList());
    }

    @PostMapping
    @Operation(description="Create service")
    public ResponseEntity<SystemDTO> createSystem(@RequestBody @Parameter(description="Service modifying request object") SystemRequestDTO systemDto) {
        IntegrationSystem system = this.systemMapper.toSystem(systemDto);
        system = this.systemService.create(system);
        return new ResponseEntity((Object)this.systemMapper.toDTO(system), (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/{systemId}"}, produces={"application/json"})
    @Operation(description="Modify specified service")
    public ResponseEntity<SystemDTO> updateSystem(@PathVariable @Parameter(description="Service id") String systemId, @RequestBody @Parameter(description="Service modifying request object") SystemRequestDTO systemDto) {
        log.info("Request to update system {}", (Object)systemId);
        IntegrationSystem system = this.systemService.getByIdOrNull(systemId);
        if (system != null) {
            String name = system.getName();
            this.systemMapper.mergeWithoutLabels(systemDto, system);
            this.systemService.replaceLabels(system, this.systemMapper.asLabelRequests(systemDto.getLabels()));
            system = this.systemService.save(system);
            if (!system.getName().equals(name)) {
                this.systemService.updateSystemModelCompiledLibraryAsync(system);
            }
            return ResponseEntity.ok((Object)this.systemMapper.toDTO(system));
        }
        return this.createSystem(systemDto);
    }

    @PatchMapping(value={"/{systemId}"}, produces={"application/json"})
    @Operation(description="Partially update service")
    public ResponseEntity<SystemDTO> updateSyncStatus(@PathVariable @Parameter(description="Service id") String systemId, @RequestBody @Parameter(description="Service modifying request object") SystemRequestDTO systemDto) {
        log.info("Request to update system sync status {}", (Object)systemId);
        IntegrationSystem system = this.systemService.getByIdOrNull(systemId);
        if (system != null) {
            String name = system.getName();
            this.systemMapper.patchMergeWithoutLabels(systemDto, system);
            this.systemService.replaceLabels(system, this.systemMapper.asLabelRequests(systemDto.getLabels()));
            system = this.systemService.save(system);
            if (!system.getName().equals(name)) {
                this.systemService.updateSystemModelCompiledLibraryAsync(system);
            }
            return ResponseEntity.ok((Object)this.systemMapper.toDTO(system));
        }
        return ResponseEntity.badRequest().build();
    }

    @DeleteMapping(value={"/{systemId}"})
    @Operation(description="Delete specified service")
    public void deleteSystem(@PathVariable @Parameter(description="Service id") String systemId) {
        log.info("Request to delete system {}", (Object)systemId);
        this.systemService.delete(systemId);
    }
}

