/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.rest.v1.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.ActionLog;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.EntityType;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.LogOperation;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.SpecificationGroup;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.SystemModel;
import org.qubership.integration.platform.catalog.service.ActionsLogService;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.SystemModelDTO;
import org.qubership.integration.platform.designtime.catalog.rest.v1.mapping.SystemModelMapper;
import org.qubership.integration.platform.designtime.catalog.service.SystemModelService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
@RequestMapping(value={"/v1/models"})
@Tag(name="system-model-controller", description="System Model Controller")
public class SystemModelController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SystemModelController.class);
    private final SystemModelMapper systemModelMapper;
    private final SystemModelService systemModelService;
    private final ActionsLogService actionLogger;

    @Autowired
    public SystemModelController(SystemModelMapper systemModelMapper, SystemModelService systemModelService, ActionsLogService actionLogger) {
        this.systemModelMapper = systemModelMapper;
        this.systemModelService = systemModelService;
        this.actionLogger = actionLogger;
    }

    @GetMapping(produces={"application/json"})
    @Operation(description="Get all specifications")
    public ResponseEntity<List<SystemModelDTO>> getModels(@RequestParam(required=false) @Parameter(description="Filter response by specification group id") String specificationGroupId, @RequestParam(required=false) @Parameter(description="Filter response by service id") String systemId) {
        List<Object> models = new ArrayList();
        if (log.isDebugEnabled()) {
            log.debug("Request to get models by system {} and specification group {}", (Object)systemId, (Object)specificationGroupId);
        }
        if (!StringUtils.isBlank((CharSequence)specificationGroupId)) {
            models = this.systemModelService.getSystemModelsBySpecificationGroupId(specificationGroupId);
        } else if (!StringUtils.isBlank((CharSequence)systemId)) {
            models = this.systemModelService.getSystemModelsBySystemId(systemId);
        }
        return ResponseEntity.ok(this.systemModelMapper.toSystemModelDTOs(models));
    }

    @GetMapping(value={"/{modelId}"}, produces={"application/json"})
    @Operation(description="Get specific specification")
    public SystemModelDTO getSystemModel(@PathVariable @Parameter(description="Specification id") String modelId) {
        if (log.isDebugEnabled()) {
            log.debug("Request to get system model {}", (Object)modelId);
        }
        SystemModel systemModel = this.systemModelService.getSystemModel(modelId);
        return this.systemModelMapper.toSystemModelDTO(systemModel);
    }

    @GetMapping(value={"/{modelId}/source"}, produces={"text/plain"})
    @Operation(description="Get raw contents of specification source")
    public String getSystemModelSource(@PathVariable @Parameter(description="Specification id") String modelId) {
        if (log.isDebugEnabled()) {
            log.debug("Request to get system model {} source", (Object)modelId);
        }
        return this.systemModelService.getMainSystemModelSource(modelId);
    }

    @PostMapping(value={"/deprecated"}, produces={"application/json"})
    @Operation(description="Make specification deprecated request")
    public ResponseEntity<SystemModelDTO> makeSystemModelDeprecated(@RequestBody @Parameter(description="Specification id") String modelId) {
        log.info("Request to make system model {} deprecated", (Object)modelId);
        SystemModel systemModel = this.systemModelService.getSystemModel(modelId);
        if (systemModel != null) {
            systemModel.setDeprecated(true);
            systemModel = this.systemModelService.update(systemModel);
            this.logSpecAction(systemModel, systemModel.getSpecificationGroup(), LogOperation.DEPRECATE);
            return ResponseEntity.ok((Object)this.systemModelMapper.toSystemModelDTO(systemModel));
        }
        return ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"/{modelId}"}, produces={"application/json"})
    @Operation(description="Delete specification")
    public ResponseEntity<Void> deleteSystemModel(@PathVariable @Parameter(description="Specification id") String modelId) {
        log.info("Request to delete system model {}", (Object)modelId);
        SystemModel systemModel = this.systemModelService.getSystemModel(modelId);
        this.systemModelService.deleteSystemModel(systemModel);
        return ResponseEntity.noContent().build();
    }

    @PatchMapping(value={"/{modelId}"}, produces={"application/json"})
    @Operation(description="Partially update specification")
    public ResponseEntity<SystemModelDTO> partiallyUpdateSystemModel(@PathVariable @Parameter(description="Specification id") String modelId, @RequestBody @Parameter(description="Specification") SystemModelDTO model) {
        log.info("Request to partially update system model {}", (Object)modelId);
        return ResponseEntity.ok((Object)this.systemModelMapper.toSystemModelDTO(this.systemModelService.partiallyUpdate(this.systemModelMapper.asEntity(model))));
    }

    @GetMapping(value={"/latest"}, produces={"application/json"})
    @Operation(description="Get latest created specification in specified service")
    public SystemModelDTO getLatestSystemModel(@RequestParam @Parameter(description="Service id") String systemId) {
        if (log.isDebugEnabled()) {
            log.debug("Request to get latest system {} model", (Object)systemId);
        }
        SystemModel systemModel = this.systemModelService.getLatestSystemModel(systemId);
        return this.systemModelMapper.toSystemModelDTO(systemModel);
    }

    private void logSpecAction(SystemModel spec, SpecificationGroup group, LogOperation operation) {
        this.actionLogger.logAction(ActionLog.builder().entityType(EntityType.SPECIFICATION).entityId(spec.getId()).entityName(spec.getName()).parentType(group == null ? null : EntityType.SPECIFICATION_GROUP).parentId(group == null ? null : group.getId()).parentName(group == null ? null : group.getName()).operation(operation).build());
    }
}

