/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.rest.v1.dto.folder;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Predicate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.catalog.util.TriggerUtils;
import org.springframework.data.jpa.domain.Specification;

@Schema(description="Content filter object for a folder item request")
public class FolderContentFilter {
    @Schema(description="Whether to show only chains with http trigger in them")
    private boolean chainsWithHttpTriggers;
    @Schema(description="Whether to show only chains with at least one external service used")
    private boolean externalRoutesOnly;

    public boolean isEmpty() {
        return !this.chainsWithHttpTriggers;
    }

    public Specification<Chain> getSpecification() {
        return (Specification & Serializable)(root, query, criteriaBuilder) -> {
            query.distinct(true);
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            Join elementJoin = root.join("elements", JoinType.INNER);
            if (this.chainsWithHttpTriggers) {
                List<String> elementTypes = Collections.singletonList(TriggerUtils.getHttpTriggerTypeName());
                predicates.add(elementJoin.get("type").in(elementTypes));
                if (this.externalRoutesOnly) {
                    predicates.add(criteriaBuilder.equal(criteriaBuilder.function("jsonb_extract_path_text", String.class, new Expression[]{elementJoin.get("properties"), criteriaBuilder.literal((Object)"externalRoute")}), (Object)"true"));
                }
            }
            return criteriaBuilder.and(predicates.toArray(new Predicate[0]));
        };
    }

    @Generated
    public FolderContentFilter() {
    }

    @Generated
    public boolean isChainsWithHttpTriggers() {
        return this.chainsWithHttpTriggers;
    }

    @Generated
    public boolean isExternalRoutesOnly() {
        return this.externalRoutesOnly;
    }

    @Generated
    public void setChainsWithHttpTriggers(boolean chainsWithHttpTriggers) {
        this.chainsWithHttpTriggers = chainsWithHttpTriggers;
    }

    @Generated
    public void setExternalRoutesOnly(boolean externalRoutesOnly) {
        this.externalRoutesOnly = externalRoutesOnly;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FolderContentFilter)) {
            return false;
        }
        FolderContentFilter other = (FolderContentFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isChainsWithHttpTriggers() != other.isChainsWithHttpTriggers()) {
            return false;
        }
        return this.isExternalRoutesOnly() == other.isExternalRoutesOnly();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FolderContentFilter;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isChainsWithHttpTriggers() ? 79 : 97);
        result = result * 59 + (this.isExternalRoutesOnly() ? 79 : 97);
        return result;
    }

    @Generated
    public String toString() {
        return "FolderContentFilter(chainsWithHttpTriggers=" + this.isChainsWithHttpTriggers() + ", externalRoutesOnly=" + this.isExternalRoutesOnly() + ")";
    }
}

