/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.rest.v1.mapping;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.qubership.integration.platform.catalog.mapping.UserMapper;
import org.qubership.integration.platform.catalog.model.dto.BaseResponse;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.catalog.util.MapperUtils;
import org.qubership.integration.platform.designtime.catalog.rest.v1.mapping.ChainBaseMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ChainBaseMapperImpl
implements ChainBaseMapper {
    @Autowired
    private UserMapper userMapper;

    @Override
    public BaseResponse asDTO(Chain chain) {
        if (chain == null) {
            return null;
        }
        BaseResponse.BaseResponseBuilder baseResponse = BaseResponse.builder();
        baseResponse.id(chain.getId());
        baseResponse.name(chain.getName());
        baseResponse.description(chain.getDescription());
        baseResponse.createdWhen(MapperUtils.fromTimestamp((Timestamp)chain.getCreatedWhen()));
        baseResponse.createdBy(this.userMapper.asDTO(chain.getCreatedBy()));
        baseResponse.modifiedWhen(MapperUtils.fromTimestamp((Timestamp)chain.getModifiedWhen()));
        baseResponse.modifiedBy(this.userMapper.asDTO(chain.getModifiedBy()));
        return baseResponse.build();
    }

    @Override
    public List<BaseResponse> asDTO(List<Chain> chains) {
        if (chains == null) {
            return null;
        }
        ArrayList<BaseResponse> list = new ArrayList<BaseResponse>(chains.size());
        for (Chain chain : chains) {
            list.add(this.asDTO(chain));
        }
        return list;
    }
}

