/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.rest.v1.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.qubership.integration.platform.catalog.model.dto.dependency.DependencyResponse;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Dependency;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ContainerChainElement;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.dependency.DependencyRequest;

@Mapper(componentModel="spring")
public interface DependencyMapper {
    public Dependency asEntity(DependencyRequest var1);

    @Mappings(value={@Mapping(source="elementFrom.id", target="from"), @Mapping(source="elementTo.id", target="to")})
    public DependencyResponse asResponse(Dependency var1);

    public List<DependencyResponse> asResponse(List<Dependency> var1);

    default public List<DependencyResponse> extractDependencies(List<ChainElement> elements) {
        return elements.stream().map(this::extractDependencies).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    default public List<DependencyResponse> extractDependencies(ChainElement chainElement) {
        if (chainElement != null) {
            ContainerChainElement container;
            List children;
            List<DependencyResponse> outputDependencies;
            List<DependencyResponse> inputDependencies = this.asResponse(chainElement.getInputDependencies());
            if (inputDependencies == null) {
                inputDependencies = new ArrayList<DependencyResponse>();
            }
            if ((outputDependencies = this.asResponse(chainElement.getOutputDependencies())) == null) {
                outputDependencies = new ArrayList<DependencyResponse>();
            }
            HashSet<DependencyResponse> dependenciesSet = new HashSet<DependencyResponse>(inputDependencies);
            dependenciesSet.addAll(outputDependencies);
            if (chainElement instanceof ContainerChainElement && (children = (container = (ContainerChainElement)chainElement).getElements()) != null) {
                Set containerDependencies = children.stream().map(this::extractDependencies).flatMap(Collection::stream).collect(Collectors.toSet());
                dependenciesSet.addAll(containerDependencies);
            }
            return new ArrayList<DependencyResponse>(dependenciesSet);
        }
        return new ArrayList<DependencyResponse>();
    }
}

