/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.rest.v1.mapping;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mapstruct.AfterMapping;
import org.mapstruct.Mapper;
import org.mapstruct.MappingTarget;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.IntegrationSystem;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.SpecificationGroup;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.SystemModel;
import org.qubership.integration.platform.catalog.util.MapperUtils;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.discovery.DiscoveredServiceDTO;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.discovery.DiscoveredServiceGroupDTO;
import org.qubership.integration.platform.designtime.catalog.service.SystemModelService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@Mapper(componentModel="spring", uses={MapperUtils.class})
public abstract class DiscoveryServiceMapper {
    private SystemModelService systemModelService;

    @Autowired
    public void setService(SystemModelService systemModelService) {
        this.systemModelService = systemModelService;
    }

    public abstract DiscoveredServiceDTO toDiscoveredServiceDTO(IntegrationSystem var1);

    @AfterMapping
    protected void after(IntegrationSystem system, @MappingTarget DiscoveredServiceDTO discoveredServiceDTO) {
        if (system.getSpecificationGroups() == null) {
            return;
        }
        ArrayList<DiscoveredServiceGroupDTO> groupList = new ArrayList<DiscoveredServiceGroupDTO>();
        for (SpecificationGroup group : system.getSpecificationGroups()) {
            DiscoveredServiceGroupDTO discoveredServiceGroupDTO;
            if (StringUtils.isBlank((CharSequence)group.getUrl()) || StringUtils.isBlank((CharSequence)(discoveredServiceGroupDTO = this.toDiscoveredServiceGroupDTO(group)).getSpecificationId())) continue;
            groupList.add(discoveredServiceGroupDTO);
        }
        if (!CollectionUtils.isEmpty(groupList)) {
            discoveredServiceDTO.setServiceGroups(groupList);
        }
    }

    public abstract DiscoveredServiceGroupDTO toDiscoveredServiceGroupDTO(SpecificationGroup var1);

    @AfterMapping
    protected void afterGroup(SpecificationGroup group, @MappingTarget DiscoveredServiceGroupDTO discoveredServiceGroupDTO) {
        SystemModel model = this.systemModelService.getLastDiscoveredSystemModelInGroup(group.getId());
        if (model != null) {
            discoveredServiceGroupDTO.setSpecificationId(model.getId());
            discoveredServiceGroupDTO.setSpecificationName(model.getName());
        }
    }

    public abstract List<DiscoveredServiceDTO> toDiscoveredServiceDTOs(List<IntegrationSystem> var1);

    public abstract List<DiscoveredServiceGroupDTO> toDiscoveredServiceGroupDTOs(List<SpecificationGroup> var1);
}

