/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.rest.v1.mapping;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.mapstruct.CollectionMappingStrategy;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.mapstruct.NullValuePropertyMappingStrategy;
import org.qubership.integration.platform.catalog.mapping.UserMapper;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ContainerChainElement;
import org.qubership.integration.platform.catalog.util.ElementUtils;
import org.qubership.integration.platform.catalog.util.MapperUtils;
import org.qubership.integration.platform.catalog.util.StringTrimmer;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.element.ElementResponse;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.element.ElementWithChainNameResponse;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.element.ElementsCodeDTO;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.element.PatchElementRequest;
import org.springframework.beans.factory.annotation.Autowired;

@Mapper(componentModel="spring", nullValuePropertyMappingStrategy=NullValuePropertyMappingStrategy.IGNORE, collectionMappingStrategy=CollectionMappingStrategy.SETTER_PREFERRED, uses={MapperUtils.class, UserMapper.class, StringTrimmer.class})
public abstract class ElementMapper {
    @Autowired
    private ElementUtils elementUtils;

    @Mappings(value={@Mapping(source="parent.id", target="parentElementId"), @Mapping(source="chain.id", target="chainId"), @Mapping(source="swimlane.id", target="swimlaneId")})
    public abstract void elementToResponse(@MappingTarget ElementResponse var1, ChainElement var2);

    @Mappings(value={@Mapping(source="elements", target="children"), @Mapping(source="parent.id", target="parentElementId"), @Mapping(source="chain.id", target="chainId"), @Mapping(source="swimlane.id", target="swimlaneId")})
    public abstract void containerElementToResponse(@MappingTarget ElementResponse var1, ContainerChainElement var2);

    public List<ElementWithChainNameResponse> toElementWithChainNameResponses(List<Pair<String, ChainElement>> elementsPairs) {
        return elementsPairs.stream().map(pair -> {
            ElementWithChainNameResponse elementResponse = (ElementWithChainNameResponse)this.toElementResponse((ChainElement)pair.getRight(), new ElementWithChainNameResponse());
            elementResponse.setChainName((String)pair.getLeft());
            return elementResponse;
        }).collect(Collectors.toList());
    }

    public ElementResponse toElementResponse(ChainElement element) {
        return this.toElementResponse(element, new ElementResponse());
    }

    public ElementResponse toElementResponse(ChainElement element, ElementResponse response) {
        if (element instanceof ContainerChainElement) {
            this.containerElementToResponse(response, (ContainerChainElement)element);
        } else if (element != null) {
            this.elementToResponse(response, element);
        } else {
            return null;
        }
        response.setMandatoryChecksPassed(this.elementUtils.areMandatoryPropertiesPresent(element) && this.elementUtils.isMandatoryInnerElementPresent(element));
        return response;
    }

    public abstract List<ElementResponse> toElementResponses(List<ChainElement> var1);

    public abstract Map<String, ElementResponse> toElementResponses(Map<String, ChainElement> var1);

    public List<ElementResponse> toElementResponses(Chain chain) {
        return this.toElementResponses(chain.getRootElements());
    }

    public abstract void patch(@MappingTarget ChainElement var1, PatchElementRequest var2);

    public abstract void merge(@MappingTarget ChainElement var1, ChainElement var2);

    @Mapping(source="yaml", target="code")
    public abstract ElementsCodeDTO elementsCodeToDTO(String var1);
}

