/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.rest.v1.mapping;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.qubership.integration.platform.catalog.mapping.UserMapper;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ContainerChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.SwimlaneChainElement;
import org.qubership.integration.platform.catalog.util.MapperUtils;
import org.qubership.integration.platform.catalog.util.StringTrimmer;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.element.ElementResponse;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.element.ElementsCodeDTO;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.element.PatchElementRequest;
import org.qubership.integration.platform.designtime.catalog.rest.v1.mapping.ElementMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ElementMapperImpl
extends ElementMapper {
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private StringTrimmer stringTrimmer;

    @Override
    public void elementToResponse(ElementResponse target, ChainElement element) {
        String id2;
        String id1;
        if (element == null) {
            return;
        }
        String id = this.elementParentId(element);
        if (id != null) {
            target.setParentElementId(this.stringTrimmer.trimString(id));
        }
        if ((id1 = this.elementChainId(element)) != null) {
            target.setChainId(this.stringTrimmer.trimString(id1));
        }
        if ((id2 = this.elementSwimlaneId(element)) != null) {
            target.setSwimlaneId(this.stringTrimmer.trimString(id2));
        }
        if (element.getId() != null) {
            target.setId(this.stringTrimmer.trimString(element.getId()));
        }
        if (element.getName() != null) {
            target.setName(this.stringTrimmer.trimString(element.getName()));
        }
        if (element.getDescription() != null) {
            target.setDescription(this.stringTrimmer.trimString(element.getDescription()));
        }
        if (element.getCreatedWhen() != null) {
            target.setCreatedWhen(MapperUtils.fromTimestamp((Timestamp)element.getCreatedWhen()));
        }
        if (element.getCreatedBy() != null) {
            target.setCreatedBy(this.userMapper.asDTO(element.getCreatedBy()));
        }
        if (element.getModifiedWhen() != null) {
            target.setModifiedWhen(MapperUtils.fromTimestamp((Timestamp)element.getModifiedWhen()));
        }
        if (element.getModifiedBy() != null) {
            target.setModifiedBy(this.userMapper.asDTO(element.getModifiedBy()));
        }
        if (element.getType() != null) {
            target.setType(this.stringTrimmer.trimString(element.getType()));
        }
        if (element.getOriginalId() != null) {
            target.setOriginalId(this.stringTrimmer.trimString(element.getOriginalId()));
        }
        if (target.getProperties() != null) {
            Map map = this.stringTrimmer.trimMapValue(element.getProperties());
            if (map != null) {
                target.getProperties().clear();
                target.getProperties().putAll(map);
            }
        } else {
            Map map = this.stringTrimmer.trimMapValue(element.getProperties());
            if (map != null) {
                target.setProperties(map);
            }
        }
    }

    @Override
    public void containerElementToResponse(ElementResponse target, ContainerChainElement container) {
        String id2;
        String id1;
        if (container == null) {
            return;
        }
        if (target.getChildren() != null) {
            list = this.toElementResponses(container.getElements());
            if (list != null) {
                target.getChildren().clear();
                target.getChildren().addAll(list);
            }
        } else {
            list = this.toElementResponses(container.getElements());
            if (list != null) {
                target.setChildren(list);
            }
        }
        String id = this.containerParentId(container);
        if (id != null) {
            target.setParentElementId(this.stringTrimmer.trimString(id));
        }
        if ((id1 = this.containerChainId(container)) != null) {
            target.setChainId(this.stringTrimmer.trimString(id1));
        }
        if ((id2 = this.containerSwimlaneId(container)) != null) {
            target.setSwimlaneId(this.stringTrimmer.trimString(id2));
        }
        if (container.getId() != null) {
            target.setId(this.stringTrimmer.trimString(container.getId()));
        }
        if (container.getName() != null) {
            target.setName(this.stringTrimmer.trimString(container.getName()));
        }
        if (container.getDescription() != null) {
            target.setDescription(this.stringTrimmer.trimString(container.getDescription()));
        }
        if (container.getCreatedWhen() != null) {
            target.setCreatedWhen(MapperUtils.fromTimestamp((Timestamp)container.getCreatedWhen()));
        }
        if (container.getCreatedBy() != null) {
            target.setCreatedBy(this.userMapper.asDTO(container.getCreatedBy()));
        }
        if (container.getModifiedWhen() != null) {
            target.setModifiedWhen(MapperUtils.fromTimestamp((Timestamp)container.getModifiedWhen()));
        }
        if (container.getModifiedBy() != null) {
            target.setModifiedBy(this.userMapper.asDTO(container.getModifiedBy()));
        }
        if (container.getType() != null) {
            target.setType(this.stringTrimmer.trimString(container.getType()));
        }
        if (container.getOriginalId() != null) {
            target.setOriginalId(this.stringTrimmer.trimString(container.getOriginalId()));
        }
        if (target.getProperties() != null) {
            Map map = this.stringTrimmer.trimMapValue(container.getProperties());
            if (map != null) {
                target.getProperties().clear();
                target.getProperties().putAll(map);
            }
        } else {
            Map map = this.stringTrimmer.trimMapValue(container.getProperties());
            if (map != null) {
                target.setProperties(map);
            }
        }
    }

    @Override
    public List<ElementResponse> toElementResponses(List<ChainElement> elements) {
        if (elements == null) {
            return null;
        }
        ArrayList<ElementResponse> list = new ArrayList<ElementResponse>(elements.size());
        for (ChainElement chainElement : elements) {
            list.add(this.toElementResponse(chainElement));
        }
        return list;
    }

    @Override
    public Map<String, ElementResponse> toElementResponses(Map<String, ChainElement> elements) {
        if (elements == null) {
            return null;
        }
        LinkedHashMap<String, ElementResponse> map = new LinkedHashMap<String, ElementResponse>(Math.max((int)((float)elements.size() / 0.75f) + 1, 16));
        for (Map.Entry<String, ChainElement> entry : elements.entrySet()) {
            String key = this.stringTrimmer.trimString(entry.getKey());
            ElementResponse value = this.toElementResponse(entry.getValue());
            map.put(key, value);
        }
        return map;
    }

    @Override
    public void patch(ChainElement element, PatchElementRequest request) {
        if (request == null) {
            return;
        }
        if (request.getName() != null) {
            element.setName(this.stringTrimmer.trimString(request.getName()));
        }
        if (request.getDescription() != null) {
            element.setDescription(this.stringTrimmer.trimString(request.getDescription()));
        }
        if (element.getProperties() != null) {
            Map map = this.stringTrimmer.trimMapValue(request.getProperties());
            if (map != null) {
                element.getProperties().clear();
                element.getProperties().putAll(map);
            }
        } else {
            Map map = this.stringTrimmer.trimMapValue(request.getProperties());
            if (map != null) {
                element.setProperties(map);
            }
        }
        if (request.getType() != null) {
            element.setType(this.stringTrimmer.trimString(request.getType()));
        }
    }

    @Override
    public void merge(ChainElement element, ChainElement request) {
        if (request == null) {
            return;
        }
        if (request.getId() != null) {
            element.setId(this.stringTrimmer.trimString(request.getId()));
        }
        if (request.getName() != null) {
            element.setName(this.stringTrimmer.trimString(request.getName()));
        }
        if (request.getDescription() != null) {
            element.setDescription(this.stringTrimmer.trimString(request.getDescription()));
        }
        if (request.getCreatedWhen() != null) {
            element.setCreatedWhen(request.getCreatedWhen());
        }
        if (request.getModifiedWhen() != null) {
            element.setModifiedWhen(request.getModifiedWhen());
        }
        if (request.getCreatedBy() != null) {
            element.setCreatedBy(request.getCreatedBy());
        }
        if (request.getModifiedBy() != null) {
            element.setModifiedBy(request.getModifiedBy());
        }
        if (request.getChain() != null) {
            element.setChain(request.getChain());
        }
        if (request.getParent() != null) {
            if (element.getParent() == null) {
                element.setParent(ContainerChainElement.builder().build());
            }
            this.merge((ChainElement)element.getParent(), (ChainElement)request.getParent());
        }
        if (request.getSwimlane() != null) {
            if (element.getSwimlane() == null) {
                element.setSwimlane(SwimlaneChainElement.builder().build());
            }
            this.merge((ChainElement)element.getSwimlane(), (ChainElement)request.getSwimlane());
        }
        if (element.getProperties() != null) {
            map = this.stringTrimmer.trimMapValue(request.getProperties());
            if (map != null) {
                element.getProperties().clear();
                element.getProperties().putAll(map);
            }
        } else {
            map = this.stringTrimmer.trimMapValue(request.getProperties());
            if (map != null) {
                element.setProperties(map);
            }
        }
        if (request.getEnvironment() != null) {
            element.setEnvironment(request.getEnvironment());
        }
        if (request.getSnapshot() != null) {
            element.setSnapshot(request.getSnapshot());
        }
        if (request.getType() != null) {
            element.setType(this.stringTrimmer.trimString(request.getType()));
        }
        if (request.getOriginalId() != null) {
            element.setOriginalId(this.stringTrimmer.trimString(request.getOriginalId()));
        }
        if (element.getInputDependencies() != null) {
            list = request.getInputDependencies();
            if (list != null) {
                element.getInputDependencies().clear();
                element.getInputDependencies().addAll(list);
            }
        } else {
            list = request.getInputDependencies();
            if (list != null) {
                element.setInputDependencies(new ArrayList(list));
            }
        }
        if (element.getOutputDependencies() != null) {
            list1 = request.getOutputDependencies();
            if (list1 != null) {
                element.getOutputDependencies().clear();
                element.getOutputDependencies().addAll(list1);
            }
        } else {
            list1 = request.getOutputDependencies();
            if (list1 != null) {
                element.setOutputDependencies(new ArrayList(list1));
            }
        }
        if (element.getValidationAlerts() != null) {
            list2 = request.getValidationAlerts();
            if (list2 != null) {
                element.getValidationAlerts().clear();
                element.getValidationAlerts().addAll(list2);
            }
        } else {
            list2 = request.getValidationAlerts();
            if (list2 != null) {
                element.setValidationAlerts(new ArrayList(list2));
            }
        }
    }

    @Override
    public ElementsCodeDTO elementsCodeToDTO(String yaml) {
        if (yaml == null) {
            return null;
        }
        ElementsCodeDTO.ElementsCodeDTOBuilder elementsCodeDTO = ElementsCodeDTO.builder();
        elementsCodeDTO.code(this.stringTrimmer.trimString(yaml));
        return elementsCodeDTO.build();
    }

    private String elementParentId(ChainElement chainElement) {
        if (chainElement == null) {
            return null;
        }
        ContainerChainElement parent = chainElement.getParent();
        if (parent == null) {
            return null;
        }
        String id = parent.getId();
        if (id == null) {
            return null;
        }
        return id;
    }

    private String elementChainId(ChainElement chainElement) {
        if (chainElement == null) {
            return null;
        }
        Chain chain = chainElement.getChain();
        if (chain == null) {
            return null;
        }
        String id = chain.getId();
        if (id == null) {
            return null;
        }
        return id;
    }

    private String elementSwimlaneId(ChainElement chainElement) {
        if (chainElement == null) {
            return null;
        }
        SwimlaneChainElement swimlane = chainElement.getSwimlane();
        if (swimlane == null) {
            return null;
        }
        String id = swimlane.getId();
        if (id == null) {
            return null;
        }
        return id;
    }

    private String containerParentId(ContainerChainElement containerChainElement) {
        if (containerChainElement == null) {
            return null;
        }
        ContainerChainElement parent = containerChainElement.getParent();
        if (parent == null) {
            return null;
        }
        String id = parent.getId();
        if (id == null) {
            return null;
        }
        return id;
    }

    private String containerChainId(ContainerChainElement containerChainElement) {
        if (containerChainElement == null) {
            return null;
        }
        Chain chain = containerChainElement.getChain();
        if (chain == null) {
            return null;
        }
        String id = chain.getId();
        if (id == null) {
            return null;
        }
        return id;
    }

    private String containerSwimlaneId(ContainerChainElement containerChainElement) {
        if (containerChainElement == null) {
            return null;
        }
        SwimlaneChainElement swimlane = containerChainElement.getSwimlane();
        if (swimlane == null) {
            return null;
        }
        String id = swimlane.getId();
        if (id == null) {
            return null;
        }
        return id;
    }
}

