/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.rest.v1.mapping;

import java.util.ArrayList;
import java.util.List;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.Operation;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.SystemModel;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.OperationBaseDTO;
import org.qubership.integration.platform.designtime.catalog.rest.v1.mapping.ChainBaseMapper;
import org.qubership.integration.platform.designtime.catalog.rest.v1.mapping.OperationBaseMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OperationBaseMapperImpl
implements OperationBaseMapper {
    @Autowired
    private ChainBaseMapper chainBaseMapper;

    @Override
    public OperationBaseDTO toDTO(Operation operation) {
        if (operation == null) {
            return null;
        }
        OperationBaseDTO operationBaseDTO = new OperationBaseDTO();
        operationBaseDTO.setModelId(this.operationSystemModelId(operation));
        operationBaseDTO.setId(operation.getId());
        operationBaseDTO.setDescription(operation.getDescription());
        operationBaseDTO.setName(operation.getName());
        operationBaseDTO.setMethod(operation.getMethod());
        operationBaseDTO.setPath(operation.getPath());
        operationBaseDTO.setChains(this.chainBaseMapper.asDTO(operation.getChains()));
        return operationBaseDTO;
    }

    @Override
    public List<OperationBaseDTO> toDTOs(List<Operation> operations) {
        if (operations == null) {
            return null;
        }
        ArrayList<OperationBaseDTO> list = new ArrayList<OperationBaseDTO>(operations.size());
        for (Operation operation : operations) {
            list.add(this.toDTO(operation));
        }
        return list;
    }

    private String operationSystemModelId(Operation operation) {
        if (operation == null) {
            return null;
        }
        SystemModel systemModel = operation.getSystemModel();
        if (systemModel == null) {
            return null;
        }
        String id = systemModel.getId();
        if (id == null) {
            return null;
        }
        return id;
    }
}

