/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.rest.v1.mapping;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.Operation;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.SystemModel;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.OperationDTO;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.OperationInfoDTO;
import org.qubership.integration.platform.designtime.catalog.rest.v1.mapping.ChainBaseMapper;
import org.qubership.integration.platform.designtime.catalog.rest.v1.mapping.OperationMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OperationMapperImpl
implements OperationMapper {
    @Autowired
    private ChainBaseMapper chainBaseMapper;

    @Override
    public OperationDTO toOperationDTO(Operation operation) {
        if (operation == null) {
            return null;
        }
        OperationDTO operationDTO = new OperationDTO();
        operationDTO.setId(operation.getId());
        operationDTO.setName(operation.getName());
        operationDTO.setMethod(operation.getMethod());
        operationDTO.setPath(operation.getPath());
        operationDTO.setModelId(this.operationSystemModelId(operation));
        operationDTO.setSpecification(operation.getSpecification());
        operationDTO.setDescription(operation.getDescription());
        operationDTO.setChains(this.chainBaseMapper.asDTO(operation.getChains()));
        return operationDTO;
    }

    @Override
    public List<OperationDTO> toOperationDTOs(List<Operation> operations) {
        if (operations == null) {
            return null;
        }
        ArrayList<OperationDTO> list = new ArrayList<OperationDTO>(operations.size());
        for (Operation operation : operations) {
            list.add(this.toOperationDTO(operation));
        }
        return list;
    }

    @Override
    public OperationInfoDTO toOperationInfoDTO(Operation operation) {
        Map map1;
        if (operation == null) {
            return null;
        }
        OperationInfoDTO.OperationInfoDTOBuilder operationInfoDTO = OperationInfoDTO.builder();
        operationInfoDTO.id(operation.getId());
        operationInfoDTO.specification(operation.getSpecification());
        Map map = operation.getRequestSchema();
        if (map != null) {
            operationInfoDTO.requestSchema(new LinkedHashMap<String, JsonNode>(map));
        }
        if ((map1 = operation.getResponseSchemas()) != null) {
            operationInfoDTO.responseSchemas(new LinkedHashMap<String, JsonNode>(map1));
        }
        return operationInfoDTO.build();
    }

    private String operationSystemModelId(Operation operation) {
        if (operation == null) {
            return null;
        }
        SystemModel systemModel = operation.getSystemModel();
        if (systemModel == null) {
            return null;
        }
        String id = systemModel.getId();
        if (id == null) {
            return null;
        }
        return id;
    }
}

