/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.rest.v1.mapping;

import java.util.List;
import org.mapstruct.BeanMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.mapstruct.NullValuePropertyMappingStrategy;
import org.qubership.integration.platform.catalog.model.system.IntegrationSystemType;
import org.qubership.integration.platform.catalog.model.system.OperationProtocol;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.Environment;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.IntegrationSystem;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.IntegrationSystemLabel;
import org.qubership.integration.platform.catalog.util.MapperUtils;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.system.SystemDTO;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.system.SystemLabelDTO;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.system.SystemRequestDTO;

@Mapper(componentModel="spring", uses={MapperUtils.class})
public interface SystemMapper {
    @Mappings(value={@Mapping(source="system.integrationSystemType", target="type"), @Mapping(target="protocol", source="system.protocol.value"), @Mapping(target="extendedProtocol", source="system.protocol"), @Mapping(target="specification", source="system.protocol.type"), @Mapping(target="activeEnvironmentId", expression="java(getActiveEnvironmentId(system))")})
    public SystemDTO toDTO(IntegrationSystem var1);

    default public String protocolToString(OperationProtocol protocol) {
        if (protocol == null) {
            return null;
        }
        return protocol == OperationProtocol.SOAP ? "soap" : protocol.value;
    }

    @Mapping(source="dto.type", target="integrationSystemType")
    public IntegrationSystem toSystem(SystemRequestDTO var1);

    public List<SystemDTO> toResponseDTOs(List<IntegrationSystem> var1);

    @Mapping(target="labels", ignore=true)
    public void mergeWithoutLabels(SystemRequestDTO var1, @MappingTarget IntegrationSystem var2);

    @BeanMapping(nullValuePropertyMappingStrategy=NullValuePropertyMappingStrategy.IGNORE)
    @Mapping(target="labels", ignore=true)
    public void patchMergeWithoutLabels(SystemRequestDTO var1, @MappingTarget IntegrationSystem var2);

    default public String getActiveEnvironmentId(IntegrationSystem system) {
        IntegrationSystemType type = system.getIntegrationSystemType();
        if (type == IntegrationSystemType.INTERNAL || type == IntegrationSystemType.IMPLEMENTED) {
            return system.getEnvironments().isEmpty() ? null : ((Environment)system.getEnvironments().get(0)).getId();
        }
        return system.getActiveEnvironmentId();
    }

    public IntegrationSystemLabel asLabelRequest(SystemLabelDTO var1);

    public List<IntegrationSystemLabel> asLabelRequests(List<SystemLabelDTO> var1);

    public SystemLabelDTO asLabelResponse(IntegrationSystemLabel var1);

    public List<SystemLabelDTO> asLabelResponse(List<IntegrationSystemLabel> var1);
}

